/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;

public class DottedBorder
extends Border {
    private static final float GAP_MODIFIER = 1.5f;

    public DottedBorder(float width) {
        super(width);
    }

    public DottedBorder(Color color, float width) {
        super(color, width);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 1.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap + this.width);
        if (adjustedGap > this.width) {
            adjustedGap -= this.width;
        }
        float widthHalf = this.width / 2.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
            }
        }
        canvas.setLineWidth(this.width);
        canvas.setStrokeColor(this.color);
        canvas.setLineDash(this.width, adjustedGap, this.width + adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        float initialGap = this.width * 1.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap + this.width);
        if (adjustedGap > this.width) {
            adjustedGap -= this.width;
        }
        canvas.saveState().setLineWidth(this.width).setStrokeColor(this.color).setLineDash(this.width, adjustedGap, this.width + adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        return (float)(distance / gapsNum);
    }
}

