/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.EnumUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfType0Font;
import com.itextpdf.kernel.font.PdfType1Font;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.HyphenationConfig;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.FontKerning;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.OverflowWrapPropertyValue;
import com.itextpdf.layout.property.RenderingMode;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.Underline;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.MaxSumWidthHandler;
import com.itextpdf.layout.renderer.SumSumWidthHandler;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.renderer.TextPreprocessingUtil;
import com.itextpdf.layout.renderer.TypographyUtils;
import com.itextpdf.layout.splitting.BreakAllSplitCharacters;
import com.itextpdf.layout.splitting.ISplitCharacters;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRenderer
extends AbstractRenderer
implements ILeafElementRenderer {
    protected static final float TEXT_SPACE_COEFF = 1000.0f;
    static final float TYPO_ASCENDER_SCALE_COEFF = 1.2f;
    static final int UNDEFINED_FIRST_CHAR_TO_FORCE_OVERFLOW = Integer.MAX_VALUE;
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final float BOLD_SIMULATION_STROKE_COEFF = 0.033333335f;
    protected float yLineOffset;
    private PdfFont font;
    protected GlyphLine text;
    protected GlyphLine line;
    protected String strToBeConverted;
    protected boolean otfFeaturesApplied = false;
    protected float tabAnchorCharacterPosition = -1.0f;
    protected List<int[]> reversedRanges;
    protected GlyphLine savedWordBreakAtLineEnding;
    private List<Integer> specialScriptsWordBreakPoints;
    private int specialScriptFirstNotFittingIndex = -1;
    private int indexOfFirstCharacterToBeForcedToOverflow = Integer.MAX_VALUE;

    public TextRenderer(Text textElement) {
        this(textElement, textElement.getText());
    }

    public TextRenderer(Text textElement, String text) {
        super(textElement);
        this.strToBeConverted = text;
    }

    protected TextRenderer(TextRenderer other) {
        super(other);
        this.text = other.text;
        this.line = other.line;
        this.font = other.font;
        this.yLineOffset = other.yLineOffset;
        this.strToBeConverted = other.strToBeConverted;
        this.otfFeaturesApplied = other.otfFeaturesApplied;
        this.tabAnchorCharacterPosition = other.tabAnchorCharacterPosition;
        this.reversedRanges = other.reversedRanges;
        this.specialScriptsWordBreakPoints = other.specialScriptsWordBreakPoints;
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        int firstPrintPos;
        boolean overflowWrapNotNormal;
        this.updateFontAndText();
        LayoutArea area = layoutContext.getArea();
        Rectangle layoutBox = area.getBBox().clone();
        boolean noSoftWrap = Boolean.TRUE.equals(this.parent.getOwnProperty(118));
        OverflowPropertyValue overflowX = (OverflowPropertyValue)((Object)this.parent.getProperty(103));
        OverflowWrapPropertyValue overflowWrap = (OverflowWrapPropertyValue)((Object)this.getProperty(127));
        boolean bl = overflowWrapNotNormal = overflowWrap == OverflowWrapPropertyValue.ANYWHERE || overflowWrap == OverflowWrapPropertyValue.BREAK_WORD;
        if (overflowWrapNotNormal) {
            overflowX = OverflowPropertyValue.FIT;
        }
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            FloatingHelper.adjustFloatedBlockLayoutBox(this, layoutBox, null, floatRendererAreas, floatPropertyValue, overflowX);
        }
        UnitValue[] margins = this.getMargins();
        this.applyMargins(layoutBox, margins, false);
        Border[] borders = this.getBorders();
        this.applyBorderBox(layoutBox, borders, false);
        UnitValue[] paddings = this.getPaddings();
        this.applyPaddings(layoutBox, paddings, false);
        MinMaxWidth countedMinMaxWidth = new MinMaxWidth(area.getBBox().getWidth() - layoutBox.getWidth());
        AbstractWidthHandler widthHandler = noSoftWrap ? new SumSumWidthHandler(countedMinMaxWidth) : new MaxSumWidthHandler(countedMinMaxWidth);
        float leftMinWidth = -1.0f;
        float[] leftMarginBorderPadding = new float[]{margins[3].getValue(), borders[3] == null ? 0.0f : borders[3].getWidth(), paddings[3].getValue()};
        float rightMinWidth = -1.0f;
        float[] rightMarginBorderPadding = new float[]{margins[1].getValue(), borders[1] == null ? 0.0f : borders[1].getWidth(), paddings[1].getValue()};
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), 0.0f, 0.0f));
        TargetCounterHandler.addPageByID(this);
        boolean anythingPlaced = false;
        int currentTextPos = this.text.start;
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        float textRise = this.getPropertyAsFloat(72).floatValue();
        Float characterSpacing = this.getPropertyAsFloat(15);
        Float wordSpacing = this.getPropertyAsFloat(78);
        float hScale = this.getProperty(29, Float.valueOf(1.0f)).floatValue();
        ISplitCharacters splitCharacters = (ISplitCharacters)this.getProperty(62);
        float italicSkewAddition = Boolean.TRUE.equals(this.getPropertyAsBoolean(31)) ? 0.21256f * fontSize.getValue() : 0.0f;
        float boldSimulationAddition = Boolean.TRUE.equals(this.getPropertyAsBoolean(8)) ? 0.033333335f * fontSize.getValue() : 0.0f;
        this.line = new GlyphLine(this.text);
        this.line.end = -1;
        this.line.start = -1;
        float ascender = 0.0f;
        float descender = 0.0f;
        float currentLineAscender = 0.0f;
        float currentLineDescender = 0.0f;
        float currentLineHeight = 0.0f;
        int initialLineTextPos = currentTextPos;
        float currentLineWidth = 0.0f;
        int previousCharPos = -1;
        RenderingMode mode = (RenderingMode)((Object)this.getProperty(123));
        float[] ascenderDescender = TextRenderer.calculateAscenderDescender(this.font, mode);
        ascender = ascenderDescender[0];
        descender = ascenderDescender[1];
        if (RenderingMode.HTML_MODE.equals((Object)mode)) {
            currentLineAscender = ascenderDescender[0];
            currentLineDescender = ascenderDescender[1];
            currentLineHeight = (currentLineAscender - currentLineDescender) * fontSize.getValue() / 1000.0f + textRise;
        }
        this.savedWordBreakAtLineEnding = null;
        Glyph wordBreakGlyphAtLineEnding = null;
        Character tabAnchorCharacter = (Character)this.getProperty(66);
        TextLayoutResult result = null;
        OverflowPropertyValue overflowY = !layoutContext.isClippedHeight() ? OverflowPropertyValue.FIT : (OverflowPropertyValue)((Object)this.parent.getProperty(104));
        boolean isSplitForcedByNewLine = false;
        boolean forcePartialSplitOnFirstChar = false;
        boolean ignoreNewLineSymbol = false;
        boolean crlf = false;
        boolean containsPossibleBreak = false;
        HyphenationConfig hyphenationConfig = (HyphenationConfig)this.getProperty(30);
        for (firstPrintPos = currentTextPos; firstPrintPos < this.text.end && TextRenderer.noPrint(this.text.get(firstPrintPos)); ++firstPrintPos) {
        }
        while (currentTextPos < this.text.end) {
            boolean specialScriptWordSplit;
            if (TextRenderer.noPrint(this.text.get(currentTextPos))) {
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                this.line.end = Math.max(this.line.end, currentTextPos + 1);
                ++currentTextPos;
                continue;
            }
            int nonBreakablePartEnd = this.text.end - 1;
            float nonBreakablePartFullWidth = 0.0f;
            float nonBreakablePartWidthWhichDoesNotExceedAllowedWidth = 0.0f;
            float nonBreakablePartMaxAscender = 0.0f;
            float nonBreakablePartMaxDescender = 0.0f;
            float nonBreakablePartMaxHeight = 0.0f;
            int firstCharacterWhichExceedsAllowedWidth = -1;
            float nonBreakingHyphenRelatedChunkWidth = 0.0f;
            int nonBreakingHyphenRelatedChunkStart = -1;
            float beforeNonBreakingHyphenRelatedChunkMaxAscender = 0.0f;
            float beforeNonBreakingHyphenRelatedChunkMaxDescender = 0.0f;
            for (int ind = currentTextPos; ind < this.text.end; ++ind) {
                boolean endOfNonBreakablePartCausedBySplitCharacter;
                float xAdvance;
                if (TextUtil.isNewLine((Glyph)this.text.get(ind))) {
                    containsPossibleBreak = true;
                    wordBreakGlyphAtLineEnding = this.text.get(ind);
                    isSplitForcedByNewLine = true;
                    firstCharacterWhichExceedsAllowedWidth = ind + 1;
                    if (ind != firstPrintPos) {
                        ignoreNewLineSymbol = true;
                    } else {
                        forcePartialSplitOnFirstChar = true;
                    }
                    if (this.line.start == -1) {
                        this.line.start = currentTextPos;
                    }
                    if (crlf = TextUtil.isCarriageReturnFollowedByLineFeed((GlyphLine)this.text, (int)currentTextPos)) {
                        ++currentTextPos;
                    }
                    this.line.end = Math.max(this.line.end, firstCharacterWhichExceedsAllowedWidth - 1);
                    break;
                }
                Glyph currentGlyph = this.text.get(ind);
                if (TextRenderer.noPrint(currentGlyph)) {
                    boolean nextGlyphIsSpaceOrWhiteSpace;
                    boolean bl2 = nextGlyphIsSpaceOrWhiteSpace = ind + 1 < this.text.end && splitCharacters.isSplitCharacter(this.text, ind + 1) && TextUtil.isSpaceOrWhitespace((Glyph)this.text.get(ind + 1));
                    if (nextGlyphIsSpaceOrWhiteSpace && firstCharacterWhichExceedsAllowedWidth == -1) {
                        containsPossibleBreak = true;
                    }
                    if (ind + 1 != this.text.end && !nextGlyphIsSpaceOrWhiteSpace && ind + 1 < this.indexOfFirstCharacterToBeForcedToOverflow) continue;
                    if (ind + 1 >= this.indexOfFirstCharacterToBeForcedToOverflow) {
                        firstCharacterWhichExceedsAllowedWidth = currentTextPos;
                        break;
                    }
                    nonBreakablePartEnd = ind;
                    break;
                }
                if (tabAnchorCharacter != null && tabAnchorCharacter.charValue() == this.text.get(ind).getUnicode()) {
                    this.tabAnchorCharacterPosition = currentLineWidth + nonBreakablePartFullWidth;
                    tabAnchorCharacter = null;
                }
                float glyphWidth = this.getCharWidth(currentGlyph, fontSize.getValue(), Float.valueOf(hScale), characterSpacing, wordSpacing) / 1000.0f;
                float f = xAdvance = previousCharPos != -1 ? (float)this.text.get(previousCharPos).getXAdvance() : 0.0f;
                if (xAdvance != 0.0f) {
                    xAdvance = this.scaleXAdvance(xAdvance, fontSize.getValue(), Float.valueOf(hScale)) / 1000.0f;
                }
                if (!noSoftWrap && nonBreakablePartFullWidth + glyphWidth + xAdvance + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() - currentLineWidth && firstCharacterWhichExceedsAllowedWidth == -1 || ind == this.specialScriptFirstNotFittingIndex) {
                    firstCharacterWhichExceedsAllowedWidth = ind;
                    boolean spaceOrWhitespace = TextUtil.isSpaceOrWhitespace((Glyph)this.text.get(ind));
                    OverflowPropertyValue parentOverflowX = (OverflowPropertyValue)((Object)this.parent.getProperty(103));
                    if (spaceOrWhitespace || overflowWrapNotNormal && !TextRenderer.isOverflowFit(parentOverflowX)) {
                        if (spaceOrWhitespace) {
                            wordBreakGlyphAtLineEnding = currentGlyph;
                        }
                        if (ind == firstPrintPos) {
                            containsPossibleBreak = true;
                            forcePartialSplitOnFirstChar = true;
                            firstCharacterWhichExceedsAllowedWidth = ind + 1;
                            break;
                        }
                    }
                }
                if (null != hyphenationConfig) {
                    if (TextRenderer.glyphBelongsToNonBreakingHyphenRelatedChunk(this.text, ind)) {
                        if (-1 == nonBreakingHyphenRelatedChunkStart) {
                            beforeNonBreakingHyphenRelatedChunkMaxAscender = nonBreakablePartMaxAscender;
                            beforeNonBreakingHyphenRelatedChunkMaxDescender = nonBreakablePartMaxDescender;
                            nonBreakingHyphenRelatedChunkStart = ind;
                        }
                        nonBreakingHyphenRelatedChunkWidth += glyphWidth + xAdvance;
                    } else {
                        nonBreakingHyphenRelatedChunkStart = -1;
                        nonBreakingHyphenRelatedChunkWidth = 0.0f;
                    }
                }
                if (firstCharacterWhichExceedsAllowedWidth == -1 || !TextRenderer.isOverflowFit(overflowX)) {
                    nonBreakablePartWidthWhichDoesNotExceedAllowedWidth += glyphWidth + xAdvance;
                }
                nonBreakablePartMaxAscender = Math.max(nonBreakablePartMaxAscender, ascender);
                nonBreakablePartMaxDescender = Math.min(nonBreakablePartMaxDescender, descender);
                nonBreakablePartMaxHeight = (nonBreakablePartMaxAscender - nonBreakablePartMaxDescender) * fontSize.getValue() / 1000.0f + textRise;
                previousCharPos = ind;
                if (!noSoftWrap && (nonBreakablePartFullWidth += glyphWidth + xAdvance) + italicSkewAddition + boldSimulationAddition > layoutBox.getWidth() && (0.0f == nonBreakingHyphenRelatedChunkWidth || ind + 1 == this.text.end || !TextRenderer.glyphBelongsToNonBreakingHyphenRelatedChunk(this.text, ind + 1)) && TextRenderer.isOverflowFit(overflowX)) break;
                if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                    float childMinWidth = (float)((double)glyphWidth + (double)xAdvance + (double)italicSkewAddition + (double)boldSimulationAddition);
                    if (leftMinWidth == -1.0f) {
                        leftMinWidth = childMinWidth;
                    } else {
                        rightMinWidth = childMinWidth;
                    }
                    widthHandler.updateMinChildWidth(childMinWidth);
                    widthHandler.updateMaxChildWidth((float)((double)glyphWidth + (double)xAdvance));
                }
                boolean endOfWordBelongingToSpecialScripts = this.textContainsSpecialScriptGlyphs(true) && TextRenderer.findPossibleBreaksSplitPosition(this.specialScriptsWordBreakPoints, ind + 1, true) >= 0;
                boolean bl3 = endOfNonBreakablePartCausedBySplitCharacter = splitCharacters.isSplitCharacter(this.text, ind) || ind + 1 < this.text.end && splitCharacters.isSplitCharacter(this.text, ind + 1) && TextUtil.isSpaceOrWhitespace((Glyph)this.text.get(ind + 1));
                if (endOfNonBreakablePartCausedBySplitCharacter && firstCharacterWhichExceedsAllowedWidth == -1) {
                    containsPossibleBreak = true;
                }
                if (ind + 1 != this.text.end && !endOfNonBreakablePartCausedBySplitCharacter && !endOfWordBelongingToSpecialScripts && ind + 1 < this.indexOfFirstCharacterToBeForcedToOverflow) continue;
                if (ind + 1 >= this.indexOfFirstCharacterToBeForcedToOverflow && !endOfNonBreakablePartCausedBySplitCharacter) {
                    firstCharacterWhichExceedsAllowedWidth = currentTextPos;
                }
                nonBreakablePartEnd = ind;
                break;
            }
            if (firstCharacterWhichExceedsAllowedWidth == -1) {
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                this.line.end = Math.max(this.line.end, nonBreakablePartEnd + 1);
                currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                currentTextPos = nonBreakablePartEnd + 1;
                currentLineWidth += nonBreakablePartFullWidth;
                if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                    widthHandler.updateMaxChildWidth((float)((double)italicSkewAddition + (double)boldSimulationAddition));
                } else {
                    float childMinWidth = (float)((double)nonBreakablePartWidthWhichDoesNotExceedAllowedWidth + (double)italicSkewAddition + (double)boldSimulationAddition);
                    if (leftMinWidth == -1.0f) {
                        leftMinWidth = childMinWidth;
                    } else {
                        rightMinWidth = childMinWidth;
                    }
                    widthHandler.updateMinChildWidth(childMinWidth);
                    widthHandler.updateMaxChildWidth(childMinWidth);
                }
                anythingPlaced = true;
                continue;
            }
            if (Math.max(currentLineHeight, nonBreakablePartMaxHeight) > layoutBox.getHeight() && TextRenderer.isOverflowFit(overflowY)) {
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                this.line.end = Math.max(this.line.end, firstCharacterWhichExceedsAllowedWidth);
                TextRenderer[] splitResult = this.split(initialLineTextPos);
                boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
                return new TextLayoutResult(3, this.occupiedArea, splitResult[0], splitResult[1], this).setContainsPossibleBreak(containsPossibleBreak).setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
            }
            boolean wordSplit = false;
            boolean hyphenationApplied = false;
            if (hyphenationConfig != null && this.indexOfFirstCharacterToBeForcedToOverflow == Integer.MAX_VALUE) {
                if (-1 == nonBreakingHyphenRelatedChunkStart) {
                    String word;
                    Hyphenation hyph;
                    int[] wordBounds = this.getWordBoundsForHyphenation(this.text, currentTextPos, this.text.end, Math.max(currentTextPos, firstCharacterWhichExceedsAllowedWidth - 1));
                    if (wordBounds != null && (hyph = hyphenationConfig.hyphenate(word = this.text.toUnicodeString(wordBounds[0], wordBounds[1]))) != null) {
                        for (int i = hyph.length() - 1; i >= 0; --i) {
                            String pre = hyph.getPreHyphenText(i);
                            String pos = hyph.getPostHyphenText(i);
                            float currentHyphenationChoicePreTextWidth = this.getGlyphLineWidth(this.convertToGlyphLine(this.text.toUnicodeString(currentTextPos, wordBounds[0]) + pre + hyphenationConfig.getHyphenSymbol()), fontSize.getValue(), hScale, characterSpacing, wordSpacing);
                            if (!(currentLineWidth + currentHyphenationChoicePreTextWidth + italicSkewAddition + boldSimulationAddition <= layoutBox.getWidth())) continue;
                            hyphenationApplied = true;
                            if (this.line.start == -1) {
                                this.line.start = currentTextPos;
                            }
                            this.line.end = Math.max(this.line.end, wordBounds[0] + pre.length());
                            GlyphLine lineCopy = this.line.copy(this.line.start, this.line.end);
                            lineCopy.add(this.font.getGlyph((int)hyphenationConfig.getHyphenSymbol()));
                            ++lineCopy.end;
                            this.line = lineCopy;
                            currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                            currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                            currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                            currentLineWidth += currentHyphenationChoicePreTextWidth;
                            if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                                widthHandler.updateMaxChildWidth((float)((double)italicSkewAddition + (double)boldSimulationAddition));
                            } else {
                                widthHandler.updateMinChildWidth((float)((double)currentHyphenationChoicePreTextWidth + (double)italicSkewAddition + (double)boldSimulationAddition));
                                widthHandler.updateMaxChildWidth((float)((double)currentHyphenationChoicePreTextWidth + (double)italicSkewAddition + (double)boldSimulationAddition));
                            }
                            currentTextPos = wordBounds[0] + pre.length();
                            break;
                        }
                    }
                } else if (this.text.start == nonBreakingHyphenRelatedChunkStart) {
                    nonBreakingHyphenRelatedChunkWidth = 0.0f;
                    firstCharacterWhichExceedsAllowedWidth = previousCharPos + 1;
                } else {
                    firstCharacterWhichExceedsAllowedWidth = nonBreakingHyphenRelatedChunkStart;
                    nonBreakablePartFullWidth -= nonBreakingHyphenRelatedChunkWidth;
                    nonBreakablePartMaxAscender = beforeNonBreakingHyphenRelatedChunkMaxAscender;
                    nonBreakablePartMaxDescender = beforeNonBreakingHyphenRelatedChunkMaxDescender;
                }
            }
            boolean bl4 = specialScriptWordSplit = this.textContainsSpecialScriptGlyphs(true) && !isSplitForcedByNewLine && TextRenderer.isOverflowFit(overflowX);
            if (nonBreakablePartFullWidth > layoutBox.getWidth() && !anythingPlaced && !hyphenationApplied || forcePartialSplitOnFirstChar || -1 != nonBreakingHyphenRelatedChunkStart || specialScriptWordSplit) {
                if (this.line.start == -1) {
                    this.line.start = currentTextPos;
                }
                if (!crlf) {
                    currentTextPos = forcePartialSplitOnFirstChar || TextRenderer.isOverflowFit(overflowX) || specialScriptWordSplit ? firstCharacterWhichExceedsAllowedWidth : nonBreakablePartEnd + 1;
                }
                this.line.end = Math.max(this.line.end, currentTextPos);
                boolean bl5 = wordSplit = !forcePartialSplitOnFirstChar && this.text.end != currentTextPos;
                if (wordSplit || !forcePartialSplitOnFirstChar && !TextRenderer.isOverflowFit(overflowX)) {
                    currentLineAscender = Math.max(currentLineAscender, nonBreakablePartMaxAscender);
                    currentLineDescender = Math.min(currentLineDescender, nonBreakablePartMaxDescender);
                    currentLineHeight = Math.max(currentLineHeight, nonBreakablePartMaxHeight);
                    currentLineWidth += nonBreakablePartWidthWhichDoesNotExceedAllowedWidth;
                    if (OverflowWrapPropertyValue.ANYWHERE == overflowWrap) {
                        widthHandler.updateMaxChildWidth((float)((double)italicSkewAddition + (double)boldSimulationAddition));
                    } else {
                        float childMinWidth = (float)((double)nonBreakablePartWidthWhichDoesNotExceedAllowedWidth + (double)italicSkewAddition + (double)boldSimulationAddition);
                        if (leftMinWidth == -1.0f) {
                            leftMinWidth = childMinWidth;
                        } else {
                            rightMinWidth = childMinWidth;
                        }
                        widthHandler.updateMinChildWidth(childMinWidth);
                        widthHandler.updateMaxChildWidth(childMinWidth);
                    }
                } else {
                    currentLineAscender = ascender;
                    currentLineDescender = descender;
                    currentLineHeight = (currentLineAscender - currentLineDescender) * fontSize.getValue() / 1000.0f + textRise;
                    currentLineWidth += this.getCharWidth(this.line.get(this.line.start), fontSize.getValue(), Float.valueOf(hScale), characterSpacing, wordSpacing) / 1000.0f;
                }
            }
            if (this.line.end <= this.line.start) {
                boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
                return new TextLayoutResult(3, this.occupiedArea, null, this, this).setContainsPossibleBreak(containsPossibleBreak).setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
            }
            result = new TextLayoutResult(2, this.occupiedArea, null, null).setWordHasBeenSplit(wordSplit).setContainsPossibleBreak(containsPossibleBreak);
            break;
        }
        boolean isPlacingForcedWhileNothing = false;
        if (currentLineHeight > layoutBox.getHeight()) {
            if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && TextRenderer.isOverflowFit(overflowY)) {
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
                return new TextLayoutResult(3, this.occupiedArea, null, this, this).setContainsPossibleBreak(containsPossibleBreak).setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
            }
            isPlacingForcedWhileNothing = true;
        }
        this.yLineOffset = currentLineAscender * fontSize.getValue() / 1000.0f;
        this.occupiedArea.getBBox().moveDown(currentLineHeight);
        this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + currentLineHeight);
        this.occupiedArea.getBBox().setWidth(Math.max(this.occupiedArea.getBBox().getWidth(), currentLineWidth));
        layoutBox.setHeight(area.getBBox().getHeight() - currentLineHeight);
        this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() + italicSkewAddition + boldSimulationAddition);
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), margins, true);
        this.increaseYLineOffset(paddings, borders, margins);
        if (result == null) {
            result = new TextLayoutResult(1, this.occupiedArea, null, null, isPlacingForcedWhileNothing ? this : null).setContainsPossibleBreak(containsPossibleBreak);
        } else {
            TextRenderer[] split = ignoreNewLineSymbol || crlf ? this.splitIgnoreFirstNewLine(currentTextPos) : this.split(currentTextPos);
            result.setSplitForcedByNewline(isSplitForcedByNewLine);
            result.setSplitRenderer(split[0]);
            if (wordBreakGlyphAtLineEnding != null) {
                split[0].saveWordBreakIfNotYetSaved(wordBreakGlyphAtLineEnding);
            }
            if (split[1].text.start != split[1].text.end) {
                result.setOverflowRenderer(split[1]);
            } else {
                result.setStatus(1);
            }
        }
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            if (result.getStatus() == 1) {
                if (this.occupiedArea.getBBox().getWidth() > 0.0f) {
                    floatRendererAreas.add(this.occupiedArea.getBBox());
                }
            } else if (result.getStatus() == 2) {
                floatRendererAreas.add(result.getSplitRenderer().getOccupiedArea().getBBox());
            }
        }
        result.setMinMaxWidth(countedMinMaxWidth);
        if (!noSoftWrap) {
            for (float dimension : leftMarginBorderPadding) {
                leftMinWidth += dimension;
            }
            for (float dimension : rightMarginBorderPadding) {
                if (rightMinWidth < 0.0f) {
                    leftMinWidth += dimension;
                    continue;
                }
                rightMinWidth += dimension;
            }
            result.setLeftMinWidth(leftMinWidth);
            result.setRightMinWidth(rightMinWidth);
        } else {
            result.setLeftMinWidth(countedMinMaxWidth.getMinWidth());
            result.setRightMinWidth(-1.0f);
        }
        boolean[] startsEnds = this.isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(splitCharacters);
        result.setStartsWithSplitCharacterWhiteSpace(startsEnds[0]).setEndsWithSplitCharacter(startsEnds[1]);
        return result;
    }

    private void increaseYLineOffset(UnitValue[] paddings, Border[] borders, UnitValue[] margins) {
        this.yLineOffset += paddings[0] != null ? paddings[0].getValue() : 0.0f;
        this.yLineOffset += borders[0] != null ? borders[0].getWidth() : 0.0f;
        this.yLineOffset += margins[0] != null ? margins[0].getValue() : 0.0f;
    }

    public void applyOtf() {
        this.updateFontAndText();
        Character.UnicodeScript script = (Character.UnicodeScript)((Object)this.getProperty(23));
        if (!this.otfFeaturesApplied && TypographyUtils.isPdfCalligraphAvailable() && this.text.start < this.text.end) {
            FontKerning fontKerning;
            if (this.hasOtfFont()) {
                Object typographyConfig = this.getProperty(117);
                Collection<Character.UnicodeScript> supportedScripts = null;
                if (typographyConfig != null) {
                    supportedScripts = TypographyUtils.getSupportedScripts(typographyConfig);
                }
                if (supportedScripts == null) {
                    supportedScripts = TypographyUtils.getSupportedScripts();
                }
                ArrayList<ScriptRange> scriptsRanges = new ArrayList<ScriptRange>();
                if (script != null) {
                    scriptsRanges.add(new ScriptRange(script, this.text.end));
                } else {
                    ScriptRange currRange = new ScriptRange(null, this.text.end);
                    scriptsRanges.add(currRange);
                    for (int i = this.text.start; i < this.text.end; ++i) {
                        Character.UnicodeScript glyphScript;
                        int unicode = this.text.get(i).getUnicode();
                        if (unicode <= -1 || Character.UnicodeScript.COMMON.equals((Object)(glyphScript = Character.UnicodeScript.of(unicode))) || Character.UnicodeScript.UNKNOWN.equals((Object)glyphScript) || Character.UnicodeScript.INHERITED.equals((Object)glyphScript) || glyphScript == currRange.script) continue;
                        if (currRange.script == null) {
                            currRange.script = glyphScript;
                            continue;
                        }
                        currRange.rangeEnd = i;
                        currRange = new ScriptRange(glyphScript, this.text.end);
                        scriptsRanges.add(currRange);
                    }
                }
                int delta = 0;
                int origTextStart = this.text.start;
                int origTextEnd = this.text.end;
                int shapingRangeStart = this.text.start;
                for (ScriptRange scriptsRange : scriptsRanges) {
                    if (scriptsRange.script == null || !supportedScripts.contains(EnumUtil.throwIfNull((Enum)scriptsRange.script))) continue;
                    scriptsRange.rangeEnd += delta;
                    this.text.start = shapingRangeStart;
                    this.text.end = scriptsRange.rangeEnd;
                    if ((scriptsRange.script == Character.UnicodeScript.ARABIC || scriptsRange.script == Character.UnicodeScript.HEBREW) && this.parent instanceof LineRenderer) {
                        this.setProperty(7, (Object)BaseDirection.DEFAULT_BIDI);
                    }
                    TypographyUtils.applyOtfScript(this.font.getFontProgram(), this.text, scriptsRange.script, typographyConfig);
                    delta += this.text.end - scriptsRange.rangeEnd;
                    scriptsRange.rangeEnd = shapingRangeStart = this.text.end;
                }
                this.text.start = origTextStart;
                this.text.end = origTextEnd + delta;
            }
            if ((fontKerning = this.getProperty(22, FontKerning.NO)) == FontKerning.YES) {
                TypographyUtils.applyKerning(this.font.getFontProgram(), this.text);
            }
            this.otfFeaturesApplied = true;
        }
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Drawing won't be performed."}));
            return;
        }
        boolean isTagged = drawContext.isTaggingEnabled();
        LayoutTaggingHelper taggingHelper = null;
        boolean isArtifact = false;
        TagTreePointer tagPointer = null;
        if (isTagged) {
            taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
            if (taggingHelper == null) {
                isArtifact = true;
            } else {
                isArtifact = taggingHelper.isArtifact(this);
                if (!isArtifact && taggingHelper.createTag(this, tagPointer = taggingHelper.useAutoTaggingPointerAndRememberItsPosition(this))) {
                    tagPointer.getProperties().addAttributes(0, AccessibleAttributesApplier.getLayoutAttributes(this, tagPointer));
                }
            }
        }
        super.draw(drawContext);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        float leftBBoxX = this.getInnerAreaBBox().getX();
        if (this.line.end > this.line.start || this.savedWordBreakAtLineEnding != null) {
            UnitValue fontSize = this.getPropertyAsUnitValue(24);
            if (!fontSize.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(TextRenderer.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
            }
            TransparentColor fontColor = this.getPropertyAsTransparentColor(21);
            Integer textRenderingMode = (Integer)this.getProperty(71);
            Float textRise = this.getPropertyAsFloat(72);
            Float characterSpacing = this.getPropertyAsFloat(15);
            Float wordSpacing = this.getPropertyAsFloat(78);
            Float horizontalScaling = (Float)this.getProperty(29);
            float[] skew = (float[])this.getProperty(65);
            boolean italicSimulation = Boolean.TRUE.equals(this.getPropertyAsBoolean(31));
            boolean boldSimulation = Boolean.TRUE.equals(this.getPropertyAsBoolean(8));
            Float strokeWidth = null;
            if (boldSimulation) {
                textRenderingMode = 2;
                strokeWidth = Float.valueOf(fontSize.getValue() / 30.0f);
            }
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                if (isArtifact) {
                    canvas.openTag((CanvasTag)new CanvasArtifact());
                } else {
                    canvas.openTag(tagPointer.getTagReference());
                }
            }
            this.beginElementOpacityApplying(drawContext);
            canvas.saveState().beginText().setFontAndSize(this.font, fontSize.getValue());
            if (skew != null && skew.length == 2) {
                canvas.setTextMatrix(1.0f, skew[0], skew[1], 1.0f, leftBBoxX, this.getYLine());
            } else if (italicSimulation) {
                canvas.setTextMatrix(1.0f, 0.0f, 0.21256f, 1.0f, leftBBoxX, this.getYLine());
            } else {
                canvas.moveText((double)leftBBoxX, (double)this.getYLine());
            }
            if (textRenderingMode != 0) {
                canvas.setTextRenderingMode(textRenderingMode.intValue());
            }
            if (textRenderingMode == 1 || textRenderingMode == 2) {
                Color strokeColor;
                if (strokeWidth == null) {
                    strokeWidth = this.getPropertyAsFloat(64);
                }
                if (strokeWidth != null && strokeWidth.floatValue() != 1.0f) {
                    canvas.setLineWidth(strokeWidth.floatValue());
                }
                if ((strokeColor = this.getPropertyAsColor(63)) == null && fontColor != null) {
                    strokeColor = fontColor.getColor();
                }
                if (strokeColor != null) {
                    canvas.setStrokeColor(strokeColor);
                }
            }
            if (fontColor != null) {
                canvas.setFillColor(fontColor.getColor());
                fontColor.applyFillTransparency(canvas);
            }
            if (textRise != null && textRise.floatValue() != 0.0f) {
                canvas.setTextRise(textRise.floatValue());
            }
            if (characterSpacing != null && characterSpacing.floatValue() != 0.0f) {
                canvas.setCharacterSpacing(characterSpacing.floatValue());
            }
            if (wordSpacing != null && wordSpacing.floatValue() != 0.0f) {
                if (this.font instanceof PdfType0Font) {
                    for (int gInd = this.line.start; gInd < this.line.end; ++gInd) {
                        if (!TextUtil.isUni0020((Glyph)this.line.get(gInd))) continue;
                        short advance = (short)(1000.0f * wordSpacing.floatValue() / fontSize.getValue());
                        Glyph copy = new Glyph(this.line.get(gInd));
                        copy.setXAdvance(advance);
                        this.line.set(gInd, copy);
                    }
                } else {
                    canvas.setWordSpacing(wordSpacing.floatValue());
                }
            }
            if (horizontalScaling != null && horizontalScaling.floatValue() != 1.0f) {
                canvas.setHorizontalScaling(horizontalScaling.floatValue() * 100.0f);
            }
            GlyphLine.IGlyphLineFilter filter = new GlyphLine.IGlyphLineFilter(){

                public boolean accept(Glyph glyph) {
                    return !TextRenderer.noPrint(glyph);
                }
            };
            boolean appearanceStreamLayout = Boolean.TRUE.equals(this.getPropertyAsBoolean(82));
            if (this.getReversedRanges() != null) {
                boolean writeReversedChars = !appearanceStreamLayout;
                ArrayList<Integer> removedIds = new ArrayList<Integer>();
                for (int i = this.line.start; i < this.line.end; ++i) {
                    if (filter.accept(this.line.get(i))) continue;
                    removedIds.add(i);
                }
                for (int[] range : this.getReversedRanges()) {
                    TextRenderer.updateRangeBasedOnRemovedCharacters(removedIds, range);
                }
                this.line = this.line.filter(filter);
                if (writeReversedChars) {
                    canvas.showText(this.line, (Iterator)new ReversedCharsIterator(this.reversedRanges, this.line).setUseReversed(true));
                } else {
                    canvas.showText(this.line);
                }
            } else {
                if (appearanceStreamLayout) {
                    this.line.setActualText(this.line.start, this.line.end, null);
                }
                canvas.showText(this.line.filter(filter));
            }
            if (this.savedWordBreakAtLineEnding != null) {
                canvas.showText(this.savedWordBreakAtLineEnding);
            }
            canvas.endText().restoreState();
            this.endElementOpacityApplying(drawContext);
            Object underlines = this.getProperty(74);
            if (underlines instanceof List) {
                for (Object underline : (List)underlines) {
                    if (!(underline instanceof Underline)) continue;
                    this.drawSingleUnderline((Underline)underline, fontColor, canvas, fontSize.getValue(), italicSimulation ? 0.21256f : 0.0f);
                }
            } else if (underlines instanceof Underline) {
                this.drawSingleUnderline((Underline)underlines, fontColor, canvas, fontSize.getValue(), italicSimulation ? 0.21256f : 0.0f);
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        if (isTagged && !isArtifact) {
            if (this.isLastRendererForModelElement) {
                taggingHelper.finishTaggingHint(this);
            }
            taggingHelper.restoreAutoTaggingPointerPosition(this);
        }
    }

    public void trimFirst() {
        this.updateFontAndText();
        if (this.text != null) {
            Glyph glyph;
            while (this.text.start < this.text.end && TextUtil.isWhitespace((Glyph)(glyph = this.text.get(this.text.start))) && !TextUtil.isNewLine((Glyph)glyph)) {
                ++this.text.start;
            }
        }
        if (this.textContainsSpecialScriptGlyphs(true) && this.specialScriptsWordBreakPoints.get(0) == this.text.start) {
            if (this.specialScriptsWordBreakPoints.size() == 1) {
                this.specialScriptsWordBreakPoints.set(0, -1);
            } else {
                this.specialScriptsWordBreakPoints.remove(0);
            }
        }
    }

    float trimLast() {
        Glyph currentGlyph;
        int firstNonSpaceCharIndex;
        float trimmedSpace = 0.0f;
        if (this.line.end <= 0) {
            return trimmedSpace;
        }
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        Float characterSpacing = this.getPropertyAsFloat(15);
        Float wordSpacing = this.getPropertyAsFloat(78);
        float hScale = this.getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue();
        for (firstNonSpaceCharIndex = this.line.end - 1; firstNonSpaceCharIndex >= this.line.start && TextUtil.isWhitespace((Glyph)(currentGlyph = this.line.get(firstNonSpaceCharIndex))); --firstNonSpaceCharIndex) {
            this.saveWordBreakIfNotYetSaved(currentGlyph);
            float currentCharWidth = this.getCharWidth(currentGlyph, fontSize.getValue(), Float.valueOf(hScale), characterSpacing, wordSpacing) / 1000.0f;
            float xAdvance = firstNonSpaceCharIndex > this.line.start ? this.scaleXAdvance(this.line.get(firstNonSpaceCharIndex - 1).getXAdvance(), fontSize.getValue(), Float.valueOf(hScale)) / 1000.0f : 0.0f;
            trimmedSpace += currentCharWidth - xAdvance;
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - currentCharWidth);
        }
        this.line.end = firstNonSpaceCharIndex + 1;
        return trimmedSpace;
    }

    @Override
    public float getAscent() {
        return this.yLineOffset;
    }

    @Override
    public float getDescent() {
        return -(this.getOccupiedAreaBBox().getHeight() - this.yLineOffset - this.getPropertyAsFloat(72).floatValue());
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.yLineOffset - this.getPropertyAsFloat(72).floatValue();
    }

    public void moveYLineTo(float y) {
        float curYLine = this.getYLine();
        float delta = y - curYLine;
        this.occupiedArea.getBBox().setY(this.occupiedArea.getBBox().getY() + delta);
    }

    public void setText(String text) {
        this.strToBeConverted = text;
        this.updateFontAndText();
    }

    @Deprecated
    public void setText(GlyphLine text, int leftPos, int rightPos) {
        GlyphLine newText = new GlyphLine(text);
        newText.start = leftPos;
        newText.end = rightPos;
        if (this.font != null) {
            newText = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(newText, this.font);
        }
        this.setProcessedGlyphLineAndFont(newText, this.font);
    }

    public void setText(GlyphLine text, PdfFont font) {
        GlyphLine newText = new GlyphLine(text);
        newText = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(newText, font);
        this.setProcessedGlyphLineAndFont(newText, font);
    }

    public GlyphLine getText() {
        this.updateFontAndText();
        return this.text;
    }

    public int length() {
        return this.text == null ? 0 : this.text.end - this.text.start;
    }

    @Override
    public String toString() {
        return this.line != null ? this.line.toString() : null;
    }

    public int charAt(int pos) {
        return this.text.get(pos + this.text.start).getUnicode();
    }

    public float getTabAnchorCharacterPosition() {
        return this.tabAnchorCharacterPosition;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new TextRenderer((Text)this.modelElement);
    }

    public static float[] calculateAscenderDescender(PdfFont font) {
        return TextRenderer.calculateAscenderDescender(font, RenderingMode.DEFAULT_LAYOUT_MODE);
    }

    public static float[] calculateAscenderDescender(PdfFont font, RenderingMode mode) {
        float descender;
        float ascender;
        FontMetrics fontMetrics = font.getFontProgram().getFontMetrics();
        float usedTypoAscenderScaleCoeff = 1.2f;
        if (RenderingMode.HTML_MODE.equals((Object)mode) && !(font instanceof PdfType1Font)) {
            usedTypoAscenderScaleCoeff = 1.0f;
        }
        if (fontMetrics.getWinAscender() == 0 || fontMetrics.getWinDescender() == 0 || fontMetrics.getTypoAscender() == fontMetrics.getWinAscender() && fontMetrics.getTypoDescender() == fontMetrics.getWinDescender()) {
            ascender = (float)fontMetrics.getTypoAscender() * usedTypoAscenderScaleCoeff;
            descender = (float)fontMetrics.getTypoDescender() * usedTypoAscenderScaleCoeff;
        } else {
            ascender = fontMetrics.getWinAscender();
            descender = fontMetrics.getWinDescender();
        }
        return new float[]{ascender, descender};
    }

    List<int[]> getReversedRanges() {
        return this.reversedRanges;
    }

    List<int[]> initReversedRanges() {
        if (this.reversedRanges == null) {
            this.reversedRanges = new ArrayList<int[]>();
        }
        return this.reversedRanges;
    }

    TextRenderer removeReversedRanges() {
        this.reversedRanges = null;
        return this;
    }

    private TextRenderer[] splitIgnoreFirstNewLine(int currentTextPos) {
        if (TextUtil.isCarriageReturnFollowedByLineFeed((GlyphLine)this.text, (int)currentTextPos)) {
            return this.split(currentTextPos + 2);
        }
        return this.split(currentTextPos + 1);
    }

    private GlyphLine convertToGlyphLine(String text) {
        return this.font.createGlyphLine(text);
    }

    private boolean hasOtfFont() {
        return this.font instanceof PdfType0Font && this.font.getFontProgram() instanceof TrueTypeFont;
    }

    boolean textContainsSpecialScriptGlyphs(boolean analyzeSpecialScriptsWordBreakPointsOnly) {
        if (this.specialScriptsWordBreakPoints != null) {
            return !this.specialScriptsWordBreakPoints.isEmpty();
        }
        if (analyzeSpecialScriptsWordBreakPointsOnly) {
            return false;
        }
        ISplitCharacters splitCharacters = (ISplitCharacters)this.getProperty(62);
        if (splitCharacters instanceof BreakAllSplitCharacters) {
            this.specialScriptsWordBreakPoints = new ArrayList<Integer>();
        }
        for (int i = this.text.start; i < this.text.end; ++i) {
            int unicode = this.text.get(i).getUnicode();
            if (unicode > -1) {
                if (!TextRenderer.codePointIsOfSpecialScript(unicode)) continue;
                return true;
            }
            char[] chars = this.text.get(i).getChars();
            if (chars == null) continue;
            for (char ch : chars) {
                if (!TextRenderer.codePointIsOfSpecialScript(ch)) continue;
                return true;
            }
        }
        this.specialScriptsWordBreakPoints = new ArrayList<Integer>();
        return false;
    }

    void setSpecialScriptsWordBreakPoints(List<Integer> specialScriptsWordBreakPoints) {
        this.specialScriptsWordBreakPoints = specialScriptsWordBreakPoints;
    }

    List<Integer> getSpecialScriptsWordBreakPoints() {
        return this.specialScriptsWordBreakPoints;
    }

    void setSpecialScriptFirstNotFittingIndex(int lastFittingIndex) {
        this.specialScriptFirstNotFittingIndex = lastFittingIndex;
    }

    int getSpecialScriptFirstNotFittingIndex() {
        return this.specialScriptFirstNotFittingIndex;
    }

    void setIndexOfFirstCharacterToBeForcedToOverflow(int indexOfFirstCharacterToBeForcedToOverflow) {
        this.indexOfFirstCharacterToBeForcedToOverflow = indexOfFirstCharacterToBeForcedToOverflow;
    }

    @Override
    protected Rectangle getBackgroundArea(Rectangle occupiedAreaWithMargins) {
        float textRise = this.getPropertyAsFloat(72).floatValue();
        return occupiedAreaWithMargins.moveUp(textRise).decreaseHeight(textRise);
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    @Override
    protected Float getLastYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    protected int lineLength() {
        return this.line.end > 0 ? this.line.end - this.line.start : 0;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (int i = this.line.start; i < this.line.end; ++i) {
            Glyph glyph = this.line.get(i);
            if (glyph.hasPlacement()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        TextLayoutResult result = (TextLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))));
        return result.getMinMaxWidth();
    }

    protected int getNumberOfSpaces() {
        if (this.line.end <= 0) {
            return 0;
        }
        int spaces = 0;
        for (int i = this.line.start; i < this.line.end; ++i) {
            Glyph currentGlyph = this.line.get(i);
            if (currentGlyph.getUnicode() != 32) continue;
            ++spaces;
        }
        return spaces;
    }

    protected TextRenderer createSplitRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer createOverflowRenderer() {
        return (TextRenderer)this.getNextRenderer();
    }

    protected TextRenderer[] split(int initialOverflowTextPos) {
        TextRenderer splitRenderer = this.createSplitRenderer();
        GlyphLine newText = new GlyphLine(this.text);
        newText.start = this.text.start;
        newText.end = initialOverflowTextPos;
        splitRenderer.setProcessedGlyphLineAndFont(newText, this.font);
        splitRenderer.line = this.line;
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.yLineOffset = this.yLineOffset;
        splitRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        TextRenderer overflowRenderer = this.createOverflowRenderer();
        newText = new GlyphLine(this.text);
        newText.start = initialOverflowTextPos;
        newText.end = this.text.end;
        overflowRenderer.setProcessedGlyphLineAndFont(newText, this.font);
        overflowRenderer.otfFeaturesApplied = this.otfFeaturesApplied;
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        if (this.specialScriptsWordBreakPoints != null) {
            if (this.specialScriptsWordBreakPoints.isEmpty()) {
                splitRenderer.setSpecialScriptsWordBreakPoints(new ArrayList<Integer>());
                overflowRenderer.setSpecialScriptsWordBreakPoints(new ArrayList<Integer>());
            } else if (this.specialScriptsWordBreakPoints.get(0) == -1) {
                ArrayList<Integer> split = new ArrayList<Integer>(1);
                split.add(-1);
                splitRenderer.setSpecialScriptsWordBreakPoints(split);
                ArrayList<Integer> overflow = new ArrayList<Integer>(1);
                overflow.add(-1);
                overflowRenderer.setSpecialScriptsWordBreakPoints(overflow);
            } else {
                ArrayList<Integer> split;
                int splitIndex = TextRenderer.findPossibleBreaksSplitPosition(this.specialScriptsWordBreakPoints, initialOverflowTextPos, false);
                if (splitIndex > -1) {
                    splitRenderer.setSpecialScriptsWordBreakPoints(this.specialScriptsWordBreakPoints.subList(0, splitIndex + 1));
                } else {
                    split = new ArrayList<Integer>(1);
                    split.add(-1);
                    splitRenderer.setSpecialScriptsWordBreakPoints(split);
                }
                if (splitIndex + 1 < this.specialScriptsWordBreakPoints.size()) {
                    overflowRenderer.setSpecialScriptsWordBreakPoints(this.specialScriptsWordBreakPoints.subList(splitIndex + 1, this.specialScriptsWordBreakPoints.size()));
                } else {
                    split = new ArrayList(1);
                    split.add(-1);
                    overflowRenderer.setSpecialScriptsWordBreakPoints(split);
                }
            }
        }
        return new TextRenderer[]{splitRenderer, overflowRenderer};
    }

    protected void drawSingleUnderline(Underline underline, TransparentColor fontStrokeColor, PdfCanvas canvas, float fontSize, float italicAngleTan) {
        TransparentColor underlineColor = underline.getColor() != null ? new TransparentColor(underline.getColor(), underline.getOpacity()) : fontStrokeColor;
        canvas.saveState();
        if (underlineColor != null) {
            canvas.setStrokeColor(underlineColor.getColor());
            underlineColor.applyStrokeTransparency(canvas);
        }
        canvas.setLineCapStyle(underline.getLineCapStyle());
        float underlineThickness = underline.getThickness(fontSize);
        if (underlineThickness != 0.0f) {
            canvas.setLineWidth(underlineThickness);
            float yLine = this.getYLine();
            float underlineYPosition = underline.getYPosition(fontSize) + yLine;
            float italicWidthSubstraction = 0.5f * fontSize * italicAngleTan;
            Rectangle innerAreaBbox = this.getInnerAreaBBox();
            canvas.moveTo((double)innerAreaBbox.getX(), (double)underlineYPosition).lineTo((double)(innerAreaBbox.getX() + innerAreaBbox.getWidth() - italicWidthSubstraction), (double)underlineYPosition).stroke();
        }
        canvas.restoreState();
    }

    protected float calculateLineWidth() {
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TextRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        return this.getGlyphLineWidth(this.line, fontSize.getValue(), this.getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue(), this.getPropertyAsFloat(15), this.getPropertyAsFloat(78));
    }

    protected boolean resolveFonts(List<IRenderer> addTo) {
        Object font = this.getProperty(20);
        if (font instanceof PdfFont) {
            addTo.add(this);
            return false;
        }
        if (font instanceof String || font instanceof String[]) {
            if (font instanceof String) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.warn("The \"Property.FONT\" property with values of String type is deprecated, use String[] as property value type instead.");
                List<String> splitFontFamily = FontFamilySplitter.splitFontFamily((String)font);
                font = splitFontFamily.toArray(new String[splitFontFamily.size()]);
            }
            FontProvider provider = (FontProvider)this.getProperty(91);
            FontSet fontSet = (FontSet)this.getProperty(98);
            if (provider.getFontSet().isEmpty() && (fontSet == null || fontSet.isEmpty())) {
                throw new IllegalStateException("FontProvider and FontSet are empty. Cannot resolve font family name (see ElementPropertyContainer#setFontFamily) without initialized FontProvider (see RootElement#setFontProvider).");
            }
            FontCharacteristics fc = this.createFontCharacteristics();
            FontSelectorStrategy strategy = provider.getStrategy(this.strToBeConverted, Arrays.asList((String[])font), fc, fontSet);
            if (null == this.strToBeConverted || this.strToBeConverted.isEmpty()) {
                addTo.add(this);
            } else {
                while (!strategy.endOfText()) {
                    GlyphLine nextGlyphs = new GlyphLine(strategy.nextGlyphs());
                    PdfFont currentFont = strategy.getCurrentFont();
                    GlyphLine newGlyphs = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(nextGlyphs, currentFont);
                    TextRenderer textRenderer = this.createCopy(newGlyphs, currentFont);
                    addTo.add(textRenderer);
                }
            }
            return true;
        }
        throw new IllegalStateException("Invalid FONT property value type.");
    }

    @Deprecated
    protected void setGlyphLineAndFont(GlyphLine gl, PdfFont font) {
        this.setProcessedGlyphLineAndFont(gl, font);
    }

    protected void setProcessedGlyphLineAndFont(GlyphLine gl, PdfFont font) {
        this.text = gl;
        this.font = font;
        this.otfFeaturesApplied = false;
        this.strToBeConverted = null;
        this.specialScriptsWordBreakPoints = null;
        this.setProperty(20, font);
    }

    protected TextRenderer createCopy(GlyphLine gl, PdfFont font) {
        TextRenderer copy = new TextRenderer(this);
        copy.setProcessedGlyphLineAndFont(gl, font);
        return copy;
    }

    static void updateRangeBasedOnRemovedCharacters(ArrayList<Integer> removedIds, int[] range) {
        int shift = TextRenderer.numberOfElementsLessThan(removedIds, range[0]);
        range[0] = range[0] - shift;
        shift = TextRenderer.numberOfElementsLessThanOrEqual(removedIds, range[1]);
        range[1] = range[1] - shift;
    }

    static int findPossibleBreaksSplitPosition(List<Integer> list, int textStartBasedInitialOverflowTextPos, boolean amongPresentOnly) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            if (list.get(middle).compareTo(textStartBasedInitialOverflowTextPos) < 0) {
                low = middle + 1;
                continue;
            }
            if (list.get(middle).compareTo(textStartBasedInitialOverflowTextPos) > 0) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        if (!amongPresentOnly && low > 0) {
            return low - 1;
        }
        return -1;
    }

    static boolean codePointIsOfSpecialScript(int codePoint) {
        Character.UnicodeScript glyphScript = Character.UnicodeScript.of(codePoint);
        return Character.UnicodeScript.THAI == glyphScript || Character.UnicodeScript.KHMER == glyphScript || Character.UnicodeScript.LAO == glyphScript || Character.UnicodeScript.MYANMAR == glyphScript;
    }

    @Override
    PdfFont resolveFirstPdfFont(String[] font, FontProvider provider, FontCharacteristics fc, FontSet additionalFonts) {
        FontSelectorStrategy strategy = provider.getStrategy(this.strToBeConverted, Arrays.asList(font), fc, additionalFonts);
        while (!strategy.endOfText()) {
            List<Glyph> resolvedGlyphs = strategy.nextGlyphs();
            PdfFont currentFont = strategy.getCurrentFont();
            for (Glyph glyph : resolvedGlyphs) {
                if (!currentFont.containsGlyph(glyph.getUnicode())) continue;
                return currentFont;
            }
        }
        return super.resolveFirstPdfFont(font, provider, fc, additionalFonts);
    }

    boolean[] isStartsWithSplitCharWhiteSpaceAndEndsWithSplitChar(ISplitCharacters splitCharacters) {
        boolean endsWithBreak;
        boolean startsWithBreak = this.line.start < this.line.end && splitCharacters.isSplitCharacter(this.text, this.line.start) && TextUtil.isSpaceOrWhitespace((Glyph)this.text.get(this.line.start));
        boolean bl = endsWithBreak = this.line.start < this.line.end && splitCharacters.isSplitCharacter(this.text, this.line.end - 1);
        if (this.specialScriptsWordBreakPoints == null || this.specialScriptsWordBreakPoints.isEmpty()) {
            return new boolean[]{startsWithBreak, endsWithBreak};
        }
        if (!endsWithBreak) {
            endsWithBreak = this.specialScriptsWordBreakPoints.contains(this.line.end);
        }
        return new boolean[]{startsWithBreak, endsWithBreak};
    }

    private float getCharWidth(Glyph g, float fontSize, Float hScale, Float characterSpacing, Float wordSpacing) {
        if (hScale == null) {
            hScale = Float.valueOf(1.0f);
        }
        float resultWidth = (float)g.getWidth() * fontSize * hScale.floatValue();
        if (characterSpacing != null) {
            resultWidth += characterSpacing.floatValue() * hScale.floatValue() * 1000.0f;
        }
        if (wordSpacing != null && g.getUnicode() == 32) {
            resultWidth += wordSpacing.floatValue() * hScale.floatValue() * 1000.0f;
        }
        return resultWidth;
    }

    private float scaleXAdvance(float xAdvance, float fontSize, Float hScale) {
        return xAdvance * fontSize * hScale.floatValue();
    }

    private float getGlyphLineWidth(GlyphLine glyphLine, float fontSize, float hScale, Float characterSpacing, Float wordSpacing) {
        float width = 0.0f;
        for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            if (TextRenderer.noPrint(glyphLine.get(i))) continue;
            float charWidth = this.getCharWidth(glyphLine.get(i), fontSize, Float.valueOf(hScale), characterSpacing, wordSpacing);
            width += charWidth;
            float xAdvance = i != glyphLine.start ? this.scaleXAdvance(glyphLine.get(i - 1).getXAdvance(), fontSize, Float.valueOf(hScale)) : 0.0f;
            width += xAdvance;
        }
        return width / 1000.0f;
    }

    private int[] getWordBoundsForHyphenation(GlyphLine text, int leftTextPos, int rightTextPos, int wordMiddleCharPos) {
        while (wordMiddleCharPos >= leftTextPos && !this.isGlyphPartOfWordForHyphenation(text.get(wordMiddleCharPos)) && !TextUtil.isUni0020((Glyph)text.get(wordMiddleCharPos))) {
            --wordMiddleCharPos;
        }
        if (wordMiddleCharPos >= leftTextPos) {
            int right;
            int left;
            for (left = wordMiddleCharPos; left >= leftTextPos && this.isGlyphPartOfWordForHyphenation(text.get(left)); --left) {
            }
            for (right = wordMiddleCharPos; right < rightTextPos && this.isGlyphPartOfWordForHyphenation(text.get(right)); ++right) {
            }
            return new int[]{left + 1, right};
        }
        return null;
    }

    private boolean isGlyphPartOfWordForHyphenation(Glyph g) {
        return Character.isLetter((char)g.getUnicode()) || 173 == g.getUnicode();
    }

    private void updateFontAndText() {
        if (this.strToBeConverted != null) {
            PdfFont newFont;
            block3: {
                try {
                    newFont = this.getPropertyAsFont(20);
                }
                catch (ClassCastException cce) {
                    newFont = this.resolveFirstPdfFont();
                    if (this.strToBeConverted.isEmpty()) break block3;
                    Logger logger = LoggerFactory.getLogger(TextRenderer.class);
                    logger.error("The \"Property.FONT\" property must be a PdfFont object in this context.");
                }
            }
            GlyphLine newText = newFont.createGlyphLine(this.strToBeConverted);
            newText = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(newText, newFont);
            this.setProcessedGlyphLineAndFont(newText, newFont);
        }
    }

    private void saveWordBreakIfNotYetSaved(Glyph wordBreak) {
        if (this.savedWordBreakAtLineEnding == null) {
            if (TextUtil.isNewLine((Glyph)wordBreak)) {
                wordBreak = this.font.getGlyph(32);
            }
            this.savedWordBreakAtLineEnding = new GlyphLine(Collections.singletonList(wordBreak));
        }
    }

    private static int numberOfElementsLessThan(ArrayList<Integer> numbers, int n) {
        int x = Collections.binarySearch(numbers, n);
        if (x >= 0) {
            return x;
        }
        return -x - 1;
    }

    private static int numberOfElementsLessThanOrEqual(ArrayList<Integer> numbers, int n) {
        int x = Collections.binarySearch(numbers, n);
        if (x >= 0) {
            return x + 1;
        }
        return -x - 1;
    }

    private static boolean noPrint(Glyph g) {
        if (!g.hasValidUnicode()) {
            return false;
        }
        int c = g.getUnicode();
        return TextUtil.isNonPrintable((int)c);
    }

    private static boolean glyphBelongsToNonBreakingHyphenRelatedChunk(GlyphLine text, int ind) {
        return TextUtil.isNonBreakingHyphen((Glyph)text.get(ind)) || ind + 1 < text.end && TextUtil.isNonBreakingHyphen((Glyph)text.get(ind + 1)) || ind - 1 >= text.start && TextUtil.isNonBreakingHyphen((Glyph)text.get(ind - 1));
    }

    private static class ScriptRange {
        Character.UnicodeScript script;
        int rangeEnd;

        ScriptRange(Character.UnicodeScript script, int rangeEnd) {
            this.script = script;
            this.rangeEnd = rangeEnd;
        }
    }

    private static class ReversedCharsIterator
    implements Iterator<GlyphLine.GlyphLinePart> {
        private List<Integer> outStart = new ArrayList<Integer>();
        private List<Integer> outEnd = new ArrayList<Integer>();
        private List<Boolean> reversed = new ArrayList<Boolean>();
        private int currentInd = 0;
        private boolean useReversed;

        public ReversedCharsIterator(List<int[]> reversedRange, GlyphLine line) {
            if (reversedRange != null) {
                if (reversedRange.get(0)[0] > 0) {
                    this.outStart.add(0);
                    this.outEnd.add(reversedRange.get(0)[0]);
                    this.reversed.add(false);
                }
                for (int i = 0; i < reversedRange.size(); ++i) {
                    int[] range = reversedRange.get(i);
                    this.outStart.add(range[0]);
                    this.outEnd.add(range[1] + 1);
                    this.reversed.add(true);
                    if (i == reversedRange.size() - 1) continue;
                    this.outStart.add(range[1] + 1);
                    this.outEnd.add(reversedRange.get(i + 1)[0]);
                    this.reversed.add(false);
                }
                int lastIndex = reversedRange.get(reversedRange.size() - 1)[1];
                if (lastIndex < line.size() - 1) {
                    this.outStart.add(lastIndex + 1);
                    this.outEnd.add(line.size());
                    this.reversed.add(false);
                }
            } else {
                this.outStart.add(line.start);
                this.outEnd.add(line.end);
                this.reversed.add(false);
            }
        }

        public ReversedCharsIterator setUseReversed(boolean useReversed) {
            this.useReversed = useReversed;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.currentInd < this.outStart.size();
        }

        @Override
        public GlyphLine.GlyphLinePart next() {
            GlyphLine.GlyphLinePart part = new GlyphLine.GlyphLinePart(this.outStart.get(this.currentInd).intValue(), this.outEnd.get(this.currentInd).intValue()).setReversed(this.useReversed && this.reversed.get(this.currentInd) != false);
            ++this.currentInd;
            return part;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Operation not supported");
        }
    }
}

