/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua;

import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.IConformanceLevel;
import com.itextpdf.kernel.pdf.IPdfPageFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.utils.IValidationChecker;
import com.itextpdf.kernel.utils.ValidationContainer;
import com.itextpdf.pdfua.PdfUAConfig;
import com.itextpdf.pdfua.PdfUAPageFactory;
import com.itextpdf.pdfua.checkers.PdfUA1Checker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfUADocument
extends PdfDocument {
    private static final IPdfPageFactory pdfPageFactory = new PdfUAPageFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfUADocument.class);
    private PdfUAConfig config;
    private boolean warnedOnPageFlush = false;

    public PdfUADocument(PdfWriter writer, PdfUAConfig config) {
        this(writer, new DocumentProperties(), config);
    }

    public PdfUADocument(PdfWriter writer, DocumentProperties properties, PdfUAConfig config) {
        super(PdfUADocument.configureWriterProperties(writer), properties);
        this.setupUAConfiguration(config);
    }

    public PdfUADocument(PdfReader reader, PdfWriter writer, PdfUAConfig config) {
        super(reader, PdfUADocument.configureWriterProperties(writer));
        this.setupUAConfiguration(config);
    }

    public PdfUADocument(PdfReader reader, PdfWriter writer, StampingProperties properties, PdfUAConfig config) {
        super(reader, PdfUADocument.configureWriterProperties(writer), properties);
        this.setupUAConfiguration(config);
    }

    public IConformanceLevel getConformanceLevel() {
        return this.config.getConformanceLevel();
    }

    protected IPdfPageFactory getPageFactory() {
        return pdfPageFactory;
    }

    boolean isClosing() {
        return this.isClosing;
    }

    void warnOnPageFlush() {
        if (!this.warnedOnPageFlush) {
            LOGGER.warn("Page flushing is disabled in PDF/UA mode to allow UA checks to be applied. Page will only be flushed on closing.");
            this.warnedOnPageFlush = true;
        }
    }

    public void disablePageFlushingWarning() {
        this.warnedOnPageFlush = true;
    }

    private void setupUAConfiguration(PdfUAConfig config) {
        this.config = config;
        this.setTagged();
        this.getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
        this.getCatalog().setLang(new PdfString(config.getLanguage()));
        PdfDocumentInfo info = this.getDocumentInfo();
        info.setTitle(config.getTitle());
        ValidationContainer validationContainer = new ValidationContainer();
        validationContainer.addChecker((IValidationChecker)new PdfUA1Checker(this));
        this.getDiContainer().register(ValidationContainer.class, (Object)validationContainer);
    }

    private static PdfWriter configureWriterProperties(PdfWriter writer) {
        writer.getProperties().addUAXmpMetadata();
        return writer;
    }
}

