/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.ITagTreeIteratorHandler;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreeIterator;
import com.itextpdf.kernel.utils.IValidationChecker;
import com.itextpdf.kernel.utils.ValidationContext;
import com.itextpdf.kernel.utils.checkers.FontCheckUtil;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.pdfua.checkers.utils.AnnotationCheckUtil;
import com.itextpdf.pdfua.checkers.utils.BCP47Validator;
import com.itextpdf.pdfua.checkers.utils.FormCheckUtil;
import com.itextpdf.pdfua.checkers.utils.FormulaCheckUtil;
import com.itextpdf.pdfua.checkers.utils.GraphicsCheckUtil;
import com.itextpdf.pdfua.checkers.utils.LayoutCheckUtil;
import com.itextpdf.pdfua.checkers.utils.NoteCheckUtil;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.checkers.utils.XfaCheckUtil;
import com.itextpdf.pdfua.checkers.utils.headings.HeadingsChecker;
import com.itextpdf.pdfua.checkers.utils.tables.TableCheckUtil;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class PdfUA1Checker
implements IValidationChecker {
    private final PdfDocument pdfDocument;
    private final TagStructureContext tagStructureContext;
    private final HeadingsChecker headingsChecker;
    private final PdfUAValidationContext context;

    public PdfUA1Checker(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.tagStructureContext = new TagStructureContext(pdfDocument);
        this.context = new PdfUAValidationContext(pdfDocument);
        this.headingsChecker = new HeadingsChecker(this.context);
    }

    public void validateDocument(ValidationContext validationContext) {
        this.checkCatalog(validationContext.getPdfDocument().getCatalog());
        this.checkStructureTreeRoot(validationContext.getPdfDocument().getStructTreeRoot());
        this.checkFonts(validationContext.getFonts());
        XfaCheckUtil.check(validationContext.getPdfDocument());
    }

    public void validateObject(Object obj, IsoKey key, PdfResources resources, PdfStream contentStream, Object extra) {
        switch (key) {
            case LAYOUT: {
                new LayoutCheckUtil(this.context).checkRenderer(obj);
                this.headingsChecker.checkLayoutElement(obj);
                break;
            }
            case CANVAS_WRITING_CONTENT: {
                this.checkOnWritingCanvasToContent(obj);
                break;
            }
            case CANVAS_BEGIN_MARKED_CONTENT: {
                this.checkOnOpeningBeginMarkedContent(obj, extra);
                break;
            }
            case FONT: {
                this.checkText((String)obj, (PdfFont)extra);
                break;
            }
            case DUPLICATE_ID_ENTRY: {
                throw new PdfUAConformanceException(MessageFormatUtil.format((String)"ID entry '{0}' shall be unique among all elements in the document\u2019s structure hierarchy", (Object[])new Object[]{obj}));
            }
            case PDF_OBJECT: {
                this.checkPdfObject((PdfObject)obj);
                break;
            }
            case CRYPTO: {
                this.checkCrypto((PdfDictionary)obj);
            }
        }
    }

    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (!(!fileSpec.containsKey(PdfName.EF) || fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF))) {
            throw new PdfUAConformanceException("File specification dictionary shall contain f key and uf key.");
        }
    }

    private void checkText(String str, PdfFont font) {
        int index = FontCheckUtil.checkGlyphsOfText((String)str, (PdfFont)font, (FontCheckUtil.CharacterChecker)new UaCharacterChecker());
        if (index != -1) {
            throw new PdfUAConformanceException(MessageFormatUtil.format((String)"The '{0}' glyph either isn't defined in embedded font or doesn't have unicode mapping.", (Object[])new Object[]{Character.valueOf(str.charAt(index))}));
        }
    }

    protected void checkMetadata(PdfCatalog catalog) {
        if (catalog.getDocument().getPdfVersion().compareTo(PdfVersion.PDF_1_7) > 0) {
            throw new PdfUAConformanceException("Specified document pdf version isn't supported in pdf/ua.");
        }
        PdfObject pdfMetadata = ((PdfDictionary)catalog.getPdfObject()).get(PdfName.Metadata);
        if (pdfMetadata == null || !pdfMetadata.isStream()) {
            throw new PdfUAConformanceException("Document shall contain a XMP metadata stream.");
        }
        byte[] metaBytes = ((PdfStream)pdfMetadata).getBytes();
        try {
            XMPMeta metadata = XMPMetaFactory.parseFromBuffer((byte[])metaBytes);
            Integer part = metadata.getPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part");
            if (!Integer.valueOf(1).equals(part)) {
                throw new PdfUAConformanceException("Metadata shall contain correct pdfuaid:part version identifier.");
            }
            if (metadata.getProperty("http://purl.org/dc/elements/1.1/", "title") == null) {
                throw new PdfUAConformanceException("Metadata shall contain dc:title entry.");
            }
        }
        catch (XMPException e) {
            throw new PdfUAConformanceException("Document shall contain a XMP metadata stream.", (Exception)((Object)e));
        }
    }

    private void checkViewerPreferences(PdfCatalog catalog) {
        PdfDictionary viewerPreferences = ((PdfDictionary)catalog.getPdfObject()).getAsDictionary(PdfName.ViewerPreferences);
        if (viewerPreferences == null) {
            throw new PdfUAConformanceException("ViewerPreferences dictionary of the Catalog dictionary does not contain a DisplayDocTitle entry.");
        }
        PdfObject displayDocTitle = viewerPreferences.get(PdfName.DisplayDocTitle);
        if (!(displayDocTitle instanceof PdfBoolean)) {
            throw new PdfUAConformanceException("ViewerPreferences dictionary of the Catalog dictionary does not contain a DisplayDocTitle entry.");
        }
        if (PdfBoolean.FALSE.equals((Object)displayDocTitle)) {
            throw new PdfUAConformanceException("ViewerPreferences dictionary of the Catalog dictionary contains a DisplayDocTitle entry with a value of false.");
        }
    }

    private void checkOnWritingCanvasToContent(Object data) {
        Stack<Tuple2<PdfName, PdfDictionary>> tagStack = this.getTagStack(data);
        if (tagStack.isEmpty()) {
            throw new PdfUAConformanceException("Tag hasn't been added before adding content to the canvas.");
        }
        boolean insideRealContent = this.isInsideRealContent(tagStack);
        boolean insideArtifact = this.isInsideArtifact(tagStack);
        if (insideRealContent && insideArtifact) {
            throw new PdfUAConformanceException("Tagged content is present inside content marked as Artifact or vice versa.");
        }
        if (!insideRealContent && !insideArtifact) {
            throw new PdfUAConformanceException("Content is neither marked as Artifact nor tagged as real content.");
        }
    }

    private Stack<Tuple2<PdfName, PdfDictionary>> getTagStack(Object data) {
        return (Stack)data;
    }

    private void checkOnOpeningBeginMarkedContent(Object obj, Object extra) {
        Tuple2 currentBmc = (Tuple2)extra;
        this.checkStandardRoleMapping((Tuple2<PdfName, PdfDictionary>)currentBmc);
        Stack<Tuple2<PdfName, PdfDictionary>> stack = this.getTagStack(obj);
        if (stack.isEmpty()) {
            return;
        }
        boolean isRealContent = this.isRealContent((Tuple2<PdfName, PdfDictionary>)currentBmc);
        boolean isArtifact = PdfName.Artifact.equals(currentBmc.getFirst());
        if (isArtifact && this.isInsideRealContent(stack)) {
            throw new PdfUAConformanceException("Content marked as artifact may only reside in Artifact content.");
        }
        if (isRealContent && this.isInsideArtifact(stack)) {
            throw new PdfUAConformanceException("Content marked as content may not reside in Artifact content.");
        }
    }

    private void checkStandardRoleMapping(Tuple2<PdfName, PdfDictionary> tag) {
        PdfNamespace namespace = this.tagStructureContext.getDocumentDefaultNamespace();
        String role = ((PdfName)tag.getFirst()).getValue();
        if (!"Artifact".equals(role) && !this.tagStructureContext.checkIfRoleShallBeMappedToStandardRole(role, namespace)) {
            throw new PdfUAConformanceException(MessageFormatUtil.format((String)"\"{0}\" tag mapping does not terminate with a standard type.", (Object[])new Object[]{role}));
        }
    }

    private boolean isInsideArtifact(Stack<Tuple2<PdfName, PdfDictionary>> tagStack) {
        for (Tuple2 tuple2 : tagStack) {
            if (!PdfName.Artifact.equals(tuple2.getFirst())) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideRealContent(Stack<Tuple2<PdfName, PdfDictionary>> tagStack) {
        for (Tuple2 tuple2 : tagStack) {
            if (!this.isRealContent((Tuple2<PdfName, PdfDictionary>)tuple2)) continue;
            return true;
        }
        return false;
    }

    private boolean isRealContent(Tuple2<PdfName, PdfDictionary> tag) {
        if (PdfName.Artifact.equals(tag.getFirst())) {
            return false;
        }
        PdfDictionary properties = (PdfDictionary)tag.getSecond();
        if (properties == null || !properties.containsKey(PdfName.MCID)) {
            return false;
        }
        PdfMcr mcr = this.pdfDocument.getStructTreeRoot().findMcrByMcid(this.pdfDocument, properties.getAsInt(PdfName.MCID).intValue());
        if (mcr == null) {
            throw new PdfUAConformanceException("Content with MCID, but MCID wasn't found in StructTreeRoot.");
        }
        return true;
    }

    private void checkCatalog(PdfCatalog catalog) {
        PdfBoolean markInfoSuspects;
        PdfDictionary catalogDict = (PdfDictionary)catalog.getPdfObject();
        if (!catalogDict.containsKey(PdfName.Metadata)) {
            throw new PdfUAConformanceException("Metadata shall be present in the catalog dictionary");
        }
        if (!(catalogDict.get(PdfName.Lang) instanceof PdfString) || !BCP47Validator.validate(catalogDict.get(PdfName.Lang).toString())) {
            throw new PdfUAConformanceException("Document does not contain valid lang entry.");
        }
        PdfDictionary markInfo = catalogDict.getAsDictionary(PdfName.MarkInfo);
        if (markInfo != null && markInfo.containsKey(PdfName.Suspects) && (markInfoSuspects = markInfo.getAsBoolean(PdfName.Suspects)) != null && markInfoSuspects.getValue()) {
            throw new PdfUAConformanceException("Suspects entry in mark info dictionary shall not have a value of true.");
        }
        this.checkViewerPreferences(catalog);
        this.checkMetadata(catalog);
        this.checkOCProperties(catalogDict.getAsDictionary(PdfName.OCProperties));
    }

    private void checkStructureTreeRoot(PdfStructTreeRoot structTreeRoot) {
        PdfDictionary roleMap = structTreeRoot.getRoleMap();
        for (Map.Entry entry : roleMap.entrySet()) {
            String role = ((PdfName)entry.getKey()).getValue();
            IRoleMappingResolver roleMappingResolver = this.pdfDocument.getTagStructureContext().getRoleMappingResolver(role);
            if (!roleMappingResolver.currentRoleIsStandard()) continue;
            throw new PdfUAConformanceException("One or more standard types are remapped.");
        }
        TagTreeIterator tagTreeIterator = new TagTreeIterator((IStructureNode)structTreeRoot);
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new GraphicsCheckUtil.GraphicsHandler(this.context));
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new FormulaCheckUtil.FormulaTagHandler(this.context));
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new NoteCheckUtil.NoteTagHandler(this.context));
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new HeadingsChecker.HeadingHandler(this.context));
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new TableCheckUtil.TableHandler(this.context));
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new AnnotationCheckUtil.AnnotationHandler(this.context));
        tagTreeIterator.addHandler((ITagTreeIteratorHandler)new FormCheckUtil.FormTagHandler(this.context));
        tagTreeIterator.traverse();
    }

    private void checkOCProperties(PdfDictionary ocProperties) {
        if (ocProperties == null) {
            return;
        }
        if (!(ocProperties.get(PdfName.Configs) instanceof PdfArray)) {
            throw new PdfUAConformanceException("Optional Content properties configs shall be an array.");
        }
        PdfArray configs = ocProperties.getAsArray(PdfName.Configs);
        if (configs != null && !configs.isEmpty()) {
            PdfDictionary d = ocProperties.getAsDictionary(PdfName.D);
            this.checkOCGNameAndASKey(d);
            for (PdfObject config : configs) {
                this.checkOCGNameAndASKey((PdfDictionary)config);
            }
            PdfArray ocgsArray = ocProperties.getAsArray(PdfName.OCGs);
            if (ocgsArray != null) {
                for (PdfObject ocg : ocgsArray) {
                    this.checkOCGNameAndASKey((PdfDictionary)ocg);
                }
            }
        }
    }

    private void checkOCGNameAndASKey(PdfDictionary dict) {
        if (dict == null) {
            return;
        }
        if (dict.get(PdfName.AS) != null) {
            throw new PdfUAConformanceException("An AS entry appears in an Optional Content.");
        }
        if (!(dict.get(PdfName.Name) instanceof PdfString) || ((PdfString)dict.get(PdfName.Name)).toString().isEmpty()) {
            throw new PdfUAConformanceException("Name entry is missing or has an empty string as its value in an Optional Content Configuration Dictionary.");
        }
    }

    private void checkFonts(Collection<PdfFont> fontsInDocument) {
        HashSet<String> fontNamesThatAreNotEmbedded = new HashSet<String>();
        for (PdfFont font : fontsInDocument) {
            if (font.isEmbedded()) continue;
            fontNamesThatAreNotEmbedded.add(font.getFontProgram().getFontNames().getFontName());
        }
        if (!fontNamesThatAreNotEmbedded.isEmpty()) {
            throw new PdfUAConformanceException(MessageFormatUtil.format((String)"Following font(s) are not embedded: {0}", (Object[])new Object[]{String.join((CharSequence)", ", fontNamesThatAreNotEmbedded)}));
        }
    }

    private void checkCrypto(PdfDictionary encryptionDictionary) {
        if (encryptionDictionary != null) {
            if (!(encryptionDictionary.get(PdfName.P) instanceof PdfNumber)) {
                throw new PdfUAConformanceException("Permissions are absent in pdf encryption dictionary.");
            }
            int permissions = ((PdfNumber)encryptionDictionary.get(PdfName.P)).intValue();
            if ((0x200 & permissions) == 0) {
                throw new PdfUAConformanceException("10th bit of P value of Encryption dictionary should be 1 if the document is tagged.");
            }
        }
    }

    private void checkPdfObject(PdfObject obj) {
        PdfDictionary dict;
        PdfName type;
        if (obj.getType() == 3 && PdfName.Filespec.equals((Object)(type = (dict = (PdfDictionary)obj).getAsName(PdfName.Type)))) {
            this.checkFileSpec(dict);
        }
    }

    private static final class UaCharacterChecker
    implements FontCheckUtil.CharacterChecker {
        private UaCharacterChecker() {
        }

        public boolean check(int ch, PdfFont font) {
            if (font.containsGlyph(ch)) {
                return !font.getGlyph(ch).hasValidUnicode();
            }
            return true;
        }
    }
}

