/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.AnnotationCheckUtil;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public class FormCheckUtil {
    private FormCheckUtil() {
    }

    public static class FormTagHandler
    extends ContextAwareTagTreeIteratorHandler {
        public FormTagHandler(PdfUAValidationContext context) {
            super(context);
        }

        public void nextElement(IStructureNode elem) {
            boolean parentContainsTU;
            PdfStructElem form = this.context.getElementIfRoleMatches(PdfName.Form, elem);
            if (form == null) {
                return;
            }
            PdfDictionary formField = FormTagHandler.getInteractiveKidForm(form);
            if (formField == null) {
                return;
            }
            if (!AnnotationCheckUtil.isAnnotationVisible(formField)) {
                return;
            }
            boolean bl = parentContainsTU = formField.get(PdfName.Parent) != null && formField.getAsDictionary(PdfName.Parent).get(PdfName.TU) != null;
            if (formField.get(PdfName.TU) == null && !parentContainsTU && form.getAlt() == null) {
                throw new PdfUAConformanceException("Document form fields missing both TU entry and alternative description. For PdfFormfields use PdfFormfield#setAlternativeName(\"Your alternative description\"); For the layout engine use Element#getAccesibilityProperties().setAlternateDescription(\"your alternative description\")");
            }
        }

        private static PdfDictionary getInteractiveKidForm(PdfStructElem structElem) {
            PdfDictionary object = (PdfDictionary)structElem.getPdfObject();
            PdfDictionary kids = object.getAsDictionary(PdfName.K);
            if (kids != null && kids.get(PdfName.Obj) != null && PdfName.Widget.equals((Object)kids.getAsDictionary(PdfName.Obj).getAsName(PdfName.Subtype))) {
                return kids.getAsDictionary(PdfName.Obj);
            }
            return null;
        }
    }
}

