/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.forms.fields.SignatureFormFieldBuilder;
import com.itextpdf.forms.fields.properties.SignedAppearanceText;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.element.SignatureFieldAppearance;
import com.itextpdf.io.exceptions.IOException;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.properties.BackgroundImage;
import com.itextpdf.layout.properties.BackgroundPosition;
import com.itextpdf.layout.properties.BackgroundRepeat;
import com.itextpdf.layout.properties.BackgroundSize;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.signatures.CertificateInfo;
import com.itextpdf.signatures.SignatureUtil;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;

public class PdfSignatureAppearance {
    private final PdfDocument document;
    private SignatureFieldAppearance modelElement;
    private int page = 1;
    private Rectangle rect;
    private Rectangle pageRect;
    private RenderingMode renderingMode = RenderingMode.DESCRIPTION;
    private String reason = "";
    private String reasonCaption = "Reason: ";
    private String location = "";
    private String locationCaption = "Location: ";
    private String signatureCreator = "";
    private String contact = "";
    private Calendar signDate;
    private Certificate signCertificate;
    private ImageData signatureGraphic = null;
    private ImageData image;
    private float imageScale;
    private String description;
    private PdfFont font;
    private FontProvider fontProvider;
    private String[] fontFamilyNames;
    private float fontSize = 0.0f;
    private Color fontColor;
    private PdfFormXObject n0;
    private PdfFormXObject n2;
    private String fieldName = "";
    private boolean reuseAppearance = false;
    private boolean reuseAppearanceSet = false;

    protected PdfSignatureAppearance(PdfDocument document, Rectangle pageRect, int pageNumber) {
        this.document = document;
        this.pageRect = new Rectangle(pageRect);
        this.rect = new Rectangle(pageRect.getWidth(), pageRect.getHeight());
        this.page = pageNumber;
    }

    @Deprecated
    public int getPageNumber() {
        return this.page;
    }

    @Deprecated
    public PdfSignatureAppearance setPageNumber(int pageNumber) {
        this.page = pageNumber;
        this.setPageRect(this.pageRect);
        return this;
    }

    @Deprecated
    public Rectangle getPageRect() {
        return this.pageRect;
    }

    @Deprecated
    public PdfSignatureAppearance setPageRect(Rectangle pageRect) {
        this.pageRect = new Rectangle(pageRect);
        this.rect = new Rectangle(pageRect.getWidth(), pageRect.getHeight());
        return this;
    }

    @Deprecated
    public PdfFormXObject getLayer0() {
        if (this.n0 == null) {
            this.n0 = new PdfFormXObject(this.rect);
            this.n0.makeIndirect(this.document);
        }
        return this.n0;
    }

    @Deprecated
    public PdfFormXObject getLayer2() {
        if (this.n2 == null) {
            this.n2 = new PdfFormXObject(this.rect);
            this.n2.makeIndirect(this.document);
        }
        return this.n2;
    }

    @Deprecated
    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    @Deprecated
    public PdfSignatureAppearance setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    @Deprecated
    public String getReason() {
        return this.reason;
    }

    @Deprecated
    public PdfSignatureAppearance setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setReasonCaption(String reasonCaption) {
        this.reasonCaption = reasonCaption;
        return this;
    }

    @Deprecated
    public String getLocation() {
        return this.location;
    }

    @Deprecated
    public PdfSignatureAppearance setLocation(String location) {
        this.location = location;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setLocationCaption(String locationCaption) {
        this.locationCaption = locationCaption;
        return this;
    }

    @Deprecated
    public String getSignatureCreator() {
        return this.signatureCreator;
    }

    @Deprecated
    public PdfSignatureAppearance setSignatureCreator(String signatureCreator) {
        this.signatureCreator = signatureCreator;
        return this;
    }

    @Deprecated
    public String getContact() {
        return this.contact;
    }

    @Deprecated
    public PdfSignatureAppearance setContact(String contact) {
        this.contact = contact;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setCertificate(Certificate signCertificate) {
        this.signCertificate = signCertificate;
        return this;
    }

    @Deprecated
    public Certificate getCertificate() {
        return this.signCertificate;
    }

    @Deprecated
    public ImageData getSignatureGraphic() {
        return this.signatureGraphic;
    }

    @Deprecated
    public PdfSignatureAppearance setSignatureGraphic(ImageData signatureGraphic) {
        this.signatureGraphic = signatureGraphic;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setReuseAppearance(boolean reuseAppearance) {
        this.reuseAppearance = reuseAppearance;
        this.reuseAppearanceSet = true;
        return this;
    }

    @Deprecated
    public ImageData getImage() {
        return this.image;
    }

    @Deprecated
    public PdfSignatureAppearance setImage(ImageData image) {
        this.image = image;
        return this;
    }

    @Deprecated
    public float getImageScale() {
        return this.imageScale;
    }

    @Deprecated
    public PdfSignatureAppearance setImageScale(float imageScale) {
        this.imageScale = imageScale;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setLayer2Text(String text) {
        this.description = text;
        return this;
    }

    @Deprecated
    public String getLayer2Text() {
        return this.description;
    }

    @Deprecated
    public PdfFont getLayer2Font() {
        return this.font;
    }

    @Deprecated
    public PdfSignatureAppearance setLayer2Font(PdfFont font) {
        this.font = font;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setLayer2FontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Deprecated
    public float getLayer2FontSize() {
        return this.fontSize;
    }

    @Deprecated
    public PdfSignatureAppearance setLayer2FontColor(Color color) {
        this.fontColor = color;
        return this;
    }

    @Deprecated
    public Color getLayer2FontColor() {
        return this.fontColor;
    }

    public SignatureFieldAppearance getSignatureAppearance() {
        if (this.modelElement == null) {
            this.modelElement = new SignatureFieldAppearance(this.fieldName);
            this.setContent();
            this.setFontRelatedProperties();
            this.applyBackgroundImage();
        } else {
            this.populateExistingModelElement();
        }
        return this.modelElement;
    }

    @Deprecated
    public PdfSignatureAppearance setSignatureAppearance(SignatureFieldAppearance modelElement) {
        this.modelElement = modelElement;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setFontProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
        return this;
    }

    @Deprecated
    public PdfSignatureAppearance setFontFamily(String ... fontFamilyNames) {
        this.fontFamilyNames = fontFamilyNames;
        return this;
    }

    @Deprecated
    public boolean isInvisible() {
        return this.rect == null || this.rect.getWidth() == 0.0f || this.rect.getHeight() == 0.0f;
    }

    @Deprecated
    protected PdfFormXObject getAppearance() throws IOException {
        SignatureUtil signatureUtil = new SignatureUtil(this.document);
        boolean fieldExist = signatureUtil.doesSignatureFieldExist(this.fieldName);
        PdfSignatureFormField sigField = fieldExist ? (PdfSignatureFormField)PdfFormCreator.getAcroForm((PdfDocument)this.document, (boolean)true).getField(this.fieldName) : ((SignatureFormFieldBuilder)new SignatureFormFieldBuilder(this.document, this.fieldName).setWidgetRectangle(this.rect)).createSignature();
        sigField.getFirstFormAnnotation().setFormFieldElement((IFormField)this.getSignatureAppearance());
        return new PdfFormXObject(sigField.getFirstFormAnnotation().getPdfObject().getAsDictionary(PdfName.AP).getAsStream(PdfName.N));
    }

    @Deprecated
    protected Calendar getSignDate() {
        return this.signDate;
    }

    @Deprecated
    protected PdfSignatureAppearance setSignDate(Calendar signDate) {
        this.signDate = signDate;
        return this;
    }

    protected PdfSignatureAppearance setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    boolean isReuseAppearance() {
        return this.reuseAppearance;
    }

    boolean isReuseAppearanceSet() {
        return this.reuseAppearanceSet;
    }

    PdfFormXObject getBackgroundLayer() {
        return this.n0;
    }

    PdfFormXObject getSignatureAppearanceLayer() {
        return this.n2;
    }

    void applyBackgroundImage() {
        if (this.image != null) {
            BackgroundRepeat repeat = new BackgroundRepeat(BackgroundRepeat.BackgroundRepeatValue.NO_REPEAT);
            BackgroundPosition position = new BackgroundPosition().setPositionX(BackgroundPosition.PositionX.CENTER).setPositionY(BackgroundPosition.PositionY.CENTER);
            BackgroundSize size = new BackgroundSize();
            float EPS = 1.0E-5f;
            if (Math.abs(this.imageScale) < 1.0E-5f) {
                size.setBackgroundSizeToValues(UnitValue.createPercentValue((float)100.0f), UnitValue.createPercentValue((float)100.0f));
            } else if (this.imageScale < 0.0f) {
                size.setBackgroundSizeToContain();
            } else {
                size.setBackgroundSizeToValues(UnitValue.createPointValue((float)(this.imageScale * this.image.getWidth())), UnitValue.createPointValue((float)(this.imageScale * this.image.getHeight())));
            }
            this.modelElement.setBackgroundImage(new BackgroundImage.Builder().setImage((PdfXObject)new PdfImageXObject(this.image)).setBackgroundSize(size).setBackgroundRepeat(repeat).setBackgroundPosition(position).build());
        }
    }

    SignedAppearanceText generateSignatureText() {
        return new SignedAppearanceText().setSignedBy(this.getSignerName()).setSignDate(this.signDate).setReasonLine(this.reasonCaption + this.reason).setLocationLine(this.locationCaption + this.location);
    }

    private void setFontRelatedProperties() {
        if (this.fontProvider != null) {
            this.modelElement.setProperty(91, (Object)this.fontProvider);
            this.modelElement.setFontFamily(this.fontFamilyNames);
        } else {
            this.modelElement.setFont(this.font);
        }
        this.modelElement.setFontSize(this.fontSize);
        this.modelElement.setFontColor(this.fontColor);
    }

    private void setContent() {
        if (this.isInvisible()) {
            return;
        }
        switch (this.renderingMode) {
            case GRAPHIC: {
                if (this.signatureGraphic == null) {
                    throw new IllegalStateException("A signature image must be present when rendering mode is graphic and description. Use setSignatureGraphic()");
                }
                this.modelElement.setContent(this.signatureGraphic);
                break;
            }
            case GRAPHIC_AND_DESCRIPTION: {
                if (this.signatureGraphic == null) {
                    throw new IllegalStateException("A signature image must be present when rendering mode is graphic and description. Use setSignatureGraphic()");
                }
                if (this.description != null) {
                    this.modelElement.setContent(this.description, this.signatureGraphic);
                    break;
                }
                this.modelElement.setContent(this.generateSignatureText(), this.signatureGraphic);
                break;
            }
            case NAME_AND_DESCRIPTION: {
                if (this.description != null) {
                    this.modelElement.setContent(this.getSignerName(), this.description);
                    break;
                }
                this.modelElement.setContent(this.getSignerName(), this.generateSignatureText());
                break;
            }
            default: {
                if (this.description != null) {
                    this.modelElement.setContent(this.description);
                    break;
                }
                this.modelElement.setContent(this.generateSignatureText());
            }
        }
    }

    private void populateExistingModelElement() {
        this.modelElement.setSignerName(this.getSignerName());
        SignedAppearanceText signedAppearanceText = this.modelElement.getSignedAppearanceText();
        if (signedAppearanceText != null) {
            signedAppearanceText.setSignedBy(this.getSignerName()).setSignDate(this.signDate);
            if (signedAppearanceText.getReasonLine().isEmpty()) {
                signedAppearanceText.setReasonLine(this.reasonCaption + this.reason);
            }
            if (signedAppearanceText.getLocationLine().isEmpty()) {
                signedAppearanceText.setLocationLine(this.locationCaption + this.location);
            }
        }
    }

    private String getSignerName() {
        String name = null;
        CertificateInfo.X500Name x500name = CertificateInfo.getSubjectFields((X509Certificate)this.signCertificate);
        if (x500name != null && (name = x500name.getField("CN")) == null) {
            name = x500name.getField("E");
        }
        return name == null ? "" : name;
    }

    @Deprecated
    public static enum RenderingMode {
        DESCRIPTION,
        NAME_AND_DESCRIPTION,
        GRAPHIC_AND_DESCRIPTION,
        GRAPHIC;

    }
}

