/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.x509.IDistributionPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IIssuingDistributionPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IReasonFlags;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.TimestampConstants;
import com.itextpdf.signatures.validation.v1.SignatureValidationProperties;
import com.itextpdf.signatures.validation.v1.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.v1.context.CertificateSource;
import com.itextpdf.signatures.validation.v1.context.ValidationContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContext;
import com.itextpdf.signatures.validation.v1.extensions.BasicConstraintsExtension;
import com.itextpdf.signatures.validation.v1.report.CertificateReportItem;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import com.itextpdf.signatures.validation.v1.report.ValidationReport;
import java.io.IOException;
import java.security.cert.CRLReason;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CRLValidator {
    static final String CRL_CHECK = "CRL response check.";
    static final String ATTRIBUTE_CERTS_ASSERTED = "The onlyContainsAttributeCerts is asserted. Conforming CRLs issuers MUST set the onlyContainsAttributeCerts boolean to FALSE.";
    static final String CERTIFICATE_IS_UNREVOKED = "The certificate was unrevoked.";
    static final String CERTIFICATE_IS_NOT_IN_THE_CRL_SCOPE = "Certificate isn't in the current CRL scope.";
    static final String CERTIFICATE_REVOKED = "Certificate was revoked by {0} on {1}.";
    static final String CRL_ISSUER_NOT_FOUND = "Unable to validate CRL response: no issuer certificate found.";
    static final String CRL_ISSUER_NO_COMMON_ROOT = "The CRL issuer does not share the root of the inspected certificate.";
    static final String CRL_INVALID = "CRL response is invalid.";
    static final String FRESHNESS_CHECK = "CRL response is not fresh enough: this update: {0}, validation date: {1}, freshness: {2}.";
    static final String ONLY_SOME_REASONS_CHECKED = "Revocation status cannot be determined since not all reason codes are covered by the current CRL.";
    static final String SAME_REASONS_CHECK = "CRLs that cover the same reason codes were already verified.";
    static final String UPDATE_DATE_BEFORE_CHECK_DATE = "nextUpdate: {0} of CRLResponse is before validation date {1}.";
    static final int ALL_REASONS = 32895;
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final Map<Certificate, Integer> checkedReasonsMask = new HashMap<Certificate, Integer>();
    private final IssuingCertificateRetriever certificateRetriever;
    private final SignatureValidationProperties properties;
    private final ValidatorChainBuilder builder;

    CRLValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.builder = builder;
    }

    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, X509CRL crl, Date validationDate) {
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.CRL_VALIDATOR);
        if (CertificateUtil.isSelfSigned(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, "Certificate is self-signed: it cannot be revoked.", ReportItem.ReportItemStatus.INFO));
            return;
        }
        Duration freshness = this.properties.getFreshness(localContext);
        if (crl.getThisUpdate().before(DateTimeUtil.addMillisToDate((Date)validationDate, (long)(-freshness.toMillis())))) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)FRESHNESS_CHECK, (Object[])new Object[]{crl.getThisUpdate(), validationDate, freshness}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (crl.getNextUpdate() != TimestampConstants.UNDEFINED_TIMESTAMP_DATE && validationDate.after(crl.getNextUpdate())) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)UPDATE_DATE_BEFORE_CHECK_DATE, (Object[])new Object[]{crl.getNextUpdate(), validationDate}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        IIssuingDistributionPoint issuingDistPoint = CRLValidator.getIssuingDistributionPointExtension(crl);
        IDistributionPoint distributionPoint = null;
        if (!issuingDistPoint.isNull()) {
            boolean basicConstraintsCaAsserted = new BasicConstraintsExtension(true).existsInCertificate(certificate);
            if (issuingDistPoint.onlyContainsUserCerts() && basicConstraintsCaAsserted || issuingDistPoint.onlyContainsCACerts() && !basicConstraintsCaAsserted) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CERTIFICATE_IS_NOT_IN_THE_CRL_SCOPE, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            if (issuingDistPoint.onlyContainsAttributeCerts()) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, ATTRIBUTE_CERTS_ASSERTED, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            if (!issuingDistPoint.getDistributionPoint().isNull()) {
                distributionPoint = CertificateUtil.getDistributionPointByName(certificate, issuingDistPoint.getDistributionPoint());
            }
        }
        int interimReasonsMask = CRLValidator.computeInterimReasonsMask(issuingDistPoint, distributionPoint);
        Integer reasonsMask = this.checkedReasonsMask.get(certificate);
        if (reasonsMask != null && (interimReasonsMask |= reasonsMask.intValue()) == reasonsMask) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, SAME_REASONS_CHECK, ReportItem.ReportItemStatus.INFO));
        }
        this.verifyCrlIntegrity(report, localContext, certificate, crl);
        CRLValidator.verifyRevocation(report, certificate, validationDate, crl);
        if (report.getValidationResult() == ValidationReport.ValidationResult.VALID) {
            this.checkedReasonsMask.put(certificate, interimReasonsMask);
        }
        if (interimReasonsMask != 32895) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, ONLY_SOME_REASONS_CHECKED, ReportItem.ReportItemStatus.INDETERMINATE));
        }
    }

    private static void verifyRevocation(ValidationReport report, X509Certificate certificate, Date verificationDate, X509CRL crl) {
        X509CRLEntry revocation = crl.getRevokedCertificate(certificate.getSerialNumber());
        if (revocation != null) {
            Date revocationDate = revocation.getRevocationDate();
            if (verificationDate.before(revocationDate)) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)"The certificate was valid on the verification date, but has been revoked since {0}.", (Object[])new Object[]{revocationDate}), ReportItem.ReportItemStatus.INFO));
            } else if (CRLReason.REMOVE_FROM_CRL == revocation.getRevocationReason()) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)CERTIFICATE_IS_UNREVOKED, (Object[])new Object[]{revocationDate}), ReportItem.ReportItemStatus.INFO));
            } else {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)CERTIFICATE_REVOKED, (Object[])new Object[]{crl.getIssuerX500Principal(), revocation.getRevocationDate()}), ReportItem.ReportItemStatus.INVALID));
            }
        }
    }

    private static IIssuingDistributionPoint getIssuingDistributionPointExtension(X509CRL crl) {
        IASN1Primitive issuingDistPointExtension = null;
        try {
            issuingDistPointExtension = CertificateUtil.getExtensionValue(crl, FACTORY.createExtension().getIssuingDistributionPoint().getId());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FACTORY.createIssuingDistributionPoint(issuingDistPointExtension);
    }

    private static int computeInterimReasonsMask(IIssuingDistributionPoint issuingDistPoint, IDistributionPoint distributionPoint) {
        IReasonFlags reasons;
        IReasonFlags onlySomeReasons;
        int interimReasonsMask = 32895;
        if (!issuingDistPoint.isNull() && !(onlySomeReasons = issuingDistPoint.getOnlySomeReasons()).isNull()) {
            interimReasonsMask &= onlySomeReasons.intValue();
        }
        if (distributionPoint != null && !(reasons = distributionPoint.getReasons()).isNull()) {
            interimReasonsMask &= reasons.intValue();
        }
        return interimReasonsMask;
    }

    private void verifyCrlIntegrity(ValidationReport report, ValidationContext context, X509Certificate certificate, X509CRL crl) {
        Date crlIssuerDate;
        Certificate subjectRoot;
        Certificate[] certs = this.certificateRetriever.getCrlIssuerCertificates(crl);
        if (certs.length == 0) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CRL_ISSUER_NOT_FOUND, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        Certificate crlIssuer = certs[0];
        Certificate crlIssuerRoot = this.getRoot(crlIssuer);
        if (!crlIssuerRoot.equals(subjectRoot = this.getRoot(certificate))) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CRL_ISSUER_NO_COMMON_ROOT, ReportItem.ReportItemStatus.INDETERMINATE));
        }
        try {
            crl.verify(crlIssuer.getPublicKey());
        }
        catch (Exception e) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CRL_INVALID, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (TimestampConstants.UNDEFINED_TIMESTAMP_DATE != crl.getNextUpdate()) {
            crlIssuerDate = crl.getNextUpdate();
            report.addReportItem(new CertificateReportItem((X509Certificate)crlIssuer, CRL_CHECK, "Using crl nextUpdate date as validation date", ReportItem.ReportItemStatus.INFO));
        } else {
            crlIssuerDate = crl.getThisUpdate();
            report.addReportItem(new CertificateReportItem((X509Certificate)crlIssuer, CRL_CHECK, "Using crl thisUpdate date as validation date", ReportItem.ReportItemStatus.INFO));
        }
        this.builder.getCertificateChainValidator().validate(report, context.setCertificateSource(CertificateSource.CRL_ISSUER), (X509Certificate)crlIssuer, crlIssuerDate);
    }

    private Certificate getRoot(Certificate cert) {
        Certificate[] chain = this.certificateRetriever.retrieveMissingCertificates(new Certificate[]{cert});
        return chain[chain.length - 1];
    }
}

