/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.CrlClientOnline;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.validation.v1.CRLValidator;
import com.itextpdf.signatures.validation.v1.OCSPValidator;
import com.itextpdf.signatures.validation.v1.SignatureValidationProperties;
import com.itextpdf.signatures.validation.v1.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.v1.context.CertificateSource;
import com.itextpdf.signatures.validation.v1.context.ValidationContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContext;
import com.itextpdf.signatures.validation.v1.report.CertificateReportItem;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import com.itextpdf.signatures.validation.v1.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RevocationDataValidator {
    static final String REVOCATION_DATA_CHECK = "Revocation data check.";
    static final String CRL_PARSING_ERROR = "CRL is incorrectly formatted.";
    static final String NO_REVOCATION_DATA = "Certificate revocation status cannot be checked: no revocation data available or the status cannot be determined.";
    static final String SELF_SIGNED_CERTIFICATE = "Certificate is self-signed: it cannot be revoked.";
    static final String TRUSTED_OCSP_RESPONDER = "Authorized OCSP Responder certificate has id-pkix-ocsp-nocheck extension so it is trusted by the definition and no revocation checking is performed.";
    static final String VALIDITY_ASSURED = "Certificate is trusted due to validity assured - short term extension.";
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final List<IOcspClient> ocspClients = new ArrayList<IOcspClient>();
    private final List<ICrlClient> crlClients = new ArrayList<ICrlClient>();
    private final SignatureValidationProperties properties;
    private final IssuingCertificateRetriever certificateRetriever;
    private final OCSPValidator ocspValidator;
    private final CRLValidator crlValidator;

    RevocationDataValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.ocspValidator = builder.getOCSPValidator();
        this.crlValidator = builder.getCRLValidator();
    }

    public RevocationDataValidator addCrlClient(ICrlClient crlClient) {
        this.crlClients.add(crlClient);
        return this;
    }

    public RevocationDataValidator addOcspClient(IOcspClient ocspClient) {
        this.ocspClients.add(ocspClient);
        return this;
    }

    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, Date validationDate) {
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.REVOCATION_DATA_VALIDATOR);
        if (CertificateUtil.isSelfSigned(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, SELF_SIGNED_CERTIFICATE, ReportItem.ReportItemStatus.INFO));
            return;
        }
        if (CertificateUtil.getExtensionValueByOid(certificate, "0.4.0.194121.2.1") != null) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, VALIDITY_ASSURED, ReportItem.ReportItemStatus.INFO));
            return;
        }
        if (CertificateSource.OCSP_ISSUER == context.getCertificateSource() && CertificateUtil.getExtensionValueByOid(certificate, BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspNoCheck().getId()) != null) {
            report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, TRUSTED_OCSP_RESPONDER, ReportItem.ReportItemStatus.INFO));
            return;
        }
        Map<ISingleResp, IBasicOCSPResp> ocspResponsesMap = this.retrieveAllOCSPResponses(localContext, certificate);
        List<ISingleResp> singleResponses = ocspResponsesMap.keySet().stream().sorted((o1, o2) -> o2.getThisUpdate().compareTo(o1.getThisUpdate())).collect(Collectors.toList());
        List<X509CRL> crlResponses = this.retrieveAllCRLResponses(report, localContext, certificate);
        this.validateRevocationData(report, localContext, certificate, validationDate, singleResponses, ocspResponsesMap, crlResponses);
    }

    private void validateRevocationData(ValidationReport report, ValidationContext context, X509Certificate certificate, Date validationDate, List<ISingleResp> singleResponses, Map<ISingleResp, IBasicOCSPResp> ocspResponsesMap, List<X509CRL> crlResponses) {
        int i = 0;
        int j = 0;
        while (i < singleResponses.size() || j < crlResponses.size()) {
            ValidationReport revDataValidationReport = new ValidationReport();
            if (i < singleResponses.size() && (j >= crlResponses.size() || singleResponses.get(i).getThisUpdate().after(crlResponses.get(j).getThisUpdate()))) {
                this.ocspValidator.validate(revDataValidationReport, context, certificate, singleResponses.get(i), ocspResponsesMap.get(singleResponses.get(i)), validationDate);
                ++i;
            } else {
                this.crlValidator.validate(revDataValidationReport, context, certificate, crlResponses.get(j), validationDate);
                ++j;
            }
            if (ValidationReport.ValidationResult.INDETERMINATE != revDataValidationReport.getValidationResult()) {
                for (ReportItem reportItem : revDataValidationReport.getLogs()) {
                    report.addReportItem(reportItem);
                }
                return;
            }
            for (ReportItem reportItem : revDataValidationReport.getLogs()) {
                report.addReportItem(reportItem.setStatus(ReportItem.ReportItemStatus.INFO));
            }
        }
        report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, NO_REVOCATION_DATA, ReportItem.ReportItemStatus.INDETERMINATE));
    }

    private Map<ISingleResp, IBasicOCSPResp> retrieveAllOCSPResponses(ValidationContext context, X509Certificate certificate) {
        HashMap<ISingleResp, IBasicOCSPResp> ocspResponsesMap = new HashMap<ISingleResp, IBasicOCSPResp>();
        for (IOcspClient ocspClient : this.ocspClients) {
            byte[] basicOcspRespBytes = ocspClient.getEncoded(certificate, (X509Certificate)this.certificateRetriever.retrieveIssuerCertificate(certificate), null);
            if (basicOcspRespBytes == null) continue;
            try {
                IBasicOCSPResp basicOCSPResp = BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(BOUNCY_CASTLE_FACTORY.createBasicOCSPResponse(BOUNCY_CASTLE_FACTORY.createASN1Primitive(basicOcspRespBytes)));
                this.fillOcspResponsesMap(ocspResponsesMap, basicOCSPResp);
            }
            catch (IOException iOException) {}
        }
        SignatureValidationProperties.OnlineFetching onlineFetching = this.properties.getRevocationOnlineFetching(context.setValidatorContext(ValidatorContext.OCSP_VALIDATOR));
        if (SignatureValidationProperties.OnlineFetching.ALWAYS_FETCH == onlineFetching || SignatureValidationProperties.OnlineFetching.FETCH_IF_NO_OTHER_DATA_AVAILABLE == onlineFetching && ocspResponsesMap.isEmpty()) {
            IBasicOCSPResp basicOCSPResp = new OcspClientBouncyCastle(null).getBasicOCSPResp(certificate, (X509Certificate)this.certificateRetriever.retrieveIssuerCertificate(certificate), null);
            this.fillOcspResponsesMap(ocspResponsesMap, basicOCSPResp);
        }
        return ocspResponsesMap;
    }

    private void fillOcspResponsesMap(Map<ISingleResp, IBasicOCSPResp> ocspResponsesMap, IBasicOCSPResp basicOCSPResp) {
        if (basicOCSPResp != null) {
            ISingleResp[] singleResponses;
            for (ISingleResp singleResponse : singleResponses = basicOCSPResp.getResponses()) {
                ocspResponsesMap.put(singleResponse, basicOCSPResp);
            }
        }
    }

    private List<X509CRL> retrieveAllCRLResponses(ValidationReport report, ValidationContext context, X509Certificate certificate) {
        ArrayList<X509CRL> crlResponses = new ArrayList<X509CRL>();
        for (ICrlClient crlClient : this.crlClients) {
            crlResponses.addAll(this.retrieveAllCRLResponsesUsingClient(report, certificate, crlClient));
        }
        SignatureValidationProperties.OnlineFetching onLineFetching = this.properties.getRevocationOnlineFetching(context.setValidatorContext(ValidatorContext.CRL_VALIDATOR));
        if (SignatureValidationProperties.OnlineFetching.ALWAYS_FETCH == onLineFetching || SignatureValidationProperties.OnlineFetching.FETCH_IF_NO_OTHER_DATA_AVAILABLE == onLineFetching && crlResponses.isEmpty()) {
            crlResponses.addAll(this.retrieveAllCRLResponsesUsingClient(report, certificate, new CrlClientOnline()));
        }
        return crlResponses.stream().sorted((o1, o2) -> o2.getThisUpdate().compareTo(o1.getThisUpdate())).collect(Collectors.toList());
    }

    private List<X509CRL> retrieveAllCRLResponsesUsingClient(ValidationReport report, X509Certificate certificate, ICrlClient crlClient) {
        ArrayList<X509CRL> crlResponses = new ArrayList<X509CRL>();
        try {
            Collection<byte[]> crlBytesCollection = crlClient.getEncoded(certificate, null);
            for (byte[] crlBytes : crlBytesCollection) {
                try {
                    crlResponses.add((X509CRL)CertificateUtil.parseCrlFromStream(new ByteArrayInputStream(crlBytes)));
                }
                catch (Exception ignored) {
                    report.addReportItem(new CertificateReportItem(certificate, REVOCATION_DATA_CHECK, CRL_PARSING_ERROR, ReportItem.ReportItemStatus.INFO));
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return crlResponses;
    }
}

