/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1.extensions;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.v1.extensions.DynamicCertificateExtension;
import java.io.IOException;
import java.security.cert.X509Certificate;

public class DynamicBasicConstraintsExtension
extends DynamicCertificateExtension {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();

    public DynamicBasicConstraintsExtension() {
        super("2.5.29.19", FACTORY.createBasicConstraints(true).toASN1Primitive());
    }

    @Override
    public boolean existsInCertificate(X509Certificate certificate) {
        try {
            if (CertificateUtil.getExtensionValue(certificate, "2.5.29.19") == null) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return certificate.getBasicConstraints() >= this.getCertificateChainSize();
    }
}

