/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.styledxmlparser.css.resolve.CssInheritance;
import com.itextpdf.styledxmlparser.util.StyleUtil;
import com.itextpdf.svg.css.impl.SvgAttributeInheritance;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SvgNodeRendererInheritanceResolver {
    public void applyInheritanceToSubTree(ISvgNodeRenderer root, ISvgNodeRenderer subTree) {
        this.applyStyles(root, subTree);
        if (subTree instanceof AbstractBranchSvgNodeRenderer) {
            AbstractBranchSvgNodeRenderer subTreeAsBranch = (AbstractBranchSvgNodeRenderer)subTree;
            for (ISvgNodeRenderer child : subTreeAsBranch.getChildren()) {
                this.applyInheritanceToSubTree(subTreeAsBranch, child);
            }
        }
    }

    protected void applyStyles(ISvgNodeRenderer parent, ISvgNodeRenderer child) {
        if (parent != null && child != null) {
            Map childStyles = child.getAttributeMapCopy();
            if (childStyles == null) {
                childStyles = new HashMap<String, String>();
            }
            Map<String, String> parentStyles = parent.getAttributeMapCopy();
            String parentFontSize = parent.getAttribute("font-size");
            if (parentFontSize == null) {
                parentFontSize = "0";
            }
            HashSet<Object> inheritanceRules = new HashSet<Object>();
            inheritanceRules.add(new CssInheritance());
            inheritanceRules.add(new SvgAttributeInheritance());
            for (Map.Entry<String, String> parentAttribute : parentStyles.entrySet()) {
                childStyles = StyleUtil.mergeParentStyleDeclaration(childStyles, (String)parentAttribute.getKey(), (String)parentAttribute.getValue(), (String)parentFontSize, inheritanceRules);
            }
            child.setAttributesAndStyles(childStyles);
        }
    }
}

