/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.gradients.GradientColorStop;
import com.itextpdf.kernel.colors.gradients.LinearGradientBuilder;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractGradientSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.StopSvgNodeRenderer;
import java.util.ArrayList;
import java.util.List;

public class LinearGradientSvgNodeRenderer
extends AbstractGradientSvgNodeRenderer {
    @Override
    public Color createColor(SvgDrawContext context, Rectangle objectBoundingBox, float objectBoundingBoxMargin, float parentOpacity) {
        if (objectBoundingBox == null) {
            return null;
        }
        LinearGradientBuilder builder = new LinearGradientBuilder();
        for (GradientColorStop stopColor : this.parseStops(parentOpacity)) {
            builder.addColorStop(stopColor);
        }
        builder.setSpreadMethod(this.parseSpreadMethod());
        boolean isObjectBoundingBox = this.isObjectBoundingBoxUnits();
        Point[] coordinates = this.getCoordinates(context, isObjectBoundingBox);
        builder.setGradientVector(coordinates[0].getX(), coordinates[0].getY(), coordinates[1].getX(), coordinates[1].getY());
        AffineTransform gradientTransform = this.getGradientTransformToUserSpaceOnUse(objectBoundingBox, isObjectBoundingBox);
        builder.setCurrentSpaceToGradientVectorSpaceTransformation(gradientTransform);
        return builder.buildColor(objectBoundingBox.applyMargins(objectBoundingBoxMargin, objectBoundingBoxMargin, objectBoundingBoxMargin, objectBoundingBoxMargin, true), context.getCurrentCanvasTransform(), context.getCurrentCanvas().getDocument());
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        LinearGradientSvgNodeRenderer copy = new LinearGradientSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    private List<GradientColorStop> parseStops(float parentOpacity) {
        ArrayList<GradientColorStop> stopsList = new ArrayList<GradientColorStop>();
        for (StopSvgNodeRenderer stopRenderer : this.getChildStopRenderers()) {
            float[] stopColor = stopRenderer.getStopColor();
            double offset = stopRenderer.getOffset();
            stopsList.add(new GradientColorStop(stopColor, offset, GradientColorStop.OffsetType.RELATIVE));
        }
        if (!stopsList.isEmpty()) {
            GradientColorStop lastStop;
            GradientColorStop firstStop = (GradientColorStop)stopsList.get(0);
            if (firstStop.getOffset() > 0.0) {
                stopsList.add(0, new GradientColorStop(firstStop, 0.0, GradientColorStop.OffsetType.RELATIVE));
            }
            if ((lastStop = (GradientColorStop)stopsList.get(stopsList.size() - 1)).getOffset() < 1.0) {
                stopsList.add(new GradientColorStop(lastStop, 1.0, GradientColorStop.OffsetType.RELATIVE));
            }
        }
        return stopsList;
    }

    private AffineTransform getGradientTransformToUserSpaceOnUse(Rectangle objectBoundingBox, boolean isObjectBoundingBox) {
        AffineTransform svgGradientTransformation;
        AffineTransform gradientTransform = new AffineTransform();
        if (isObjectBoundingBox) {
            gradientTransform.translate((double)objectBoundingBox.getX(), (double)objectBoundingBox.getY());
            gradientTransform.scale((double)objectBoundingBox.getWidth() / 0.75, (double)objectBoundingBox.getHeight() / 0.75);
        }
        if ((svgGradientTransformation = this.getGradientTransform()) != null) {
            gradientTransform.concatenate(svgGradientTransformation);
        }
        return gradientTransform;
    }

    private Point[] getCoordinates(SvgDrawContext context, boolean isObjectBoundingBox) {
        Point end;
        Point start;
        if (isObjectBoundingBox) {
            start = new Point(this.getCoordinateForObjectBoundingBox("x1", 0.0), this.getCoordinateForObjectBoundingBox("y1", 0.0));
            end = new Point(this.getCoordinateForObjectBoundingBox("x2", 1.0), this.getCoordinateForObjectBoundingBox("y2", 0.0));
        } else {
            Rectangle currentViewPort = context.getCurrentViewPort();
            double x = currentViewPort.getX();
            double y = currentViewPort.getY();
            double width = currentViewPort.getWidth();
            double height = currentViewPort.getHeight();
            float em = this.getCurrentFontSize();
            float rem = context.getRemValue();
            start = new Point(this.getCoordinateForUserSpaceOnUse("x1", x, x, width, em, rem), this.getCoordinateForUserSpaceOnUse("y1", y, y, height, em, rem));
            end = new Point(this.getCoordinateForUserSpaceOnUse("x2", x + width, x, width, em, rem), this.getCoordinateForUserSpaceOnUse("y2", y, y, height, em, rem));
        }
        return new Point[]{start, end};
    }

    private double getCoordinateForObjectBoundingBox(String attributeName, double defaultValue) {
        int unitsPosition;
        String attributeValue = this.getAttribute(attributeName);
        double absoluteValue = defaultValue;
        if (CssUtils.isPercentageValue((String)attributeValue)) {
            absoluteValue = CssUtils.parseRelativeValue((String)attributeValue, (float)1.0f);
        } else if ((CssUtils.isNumericValue((String)attributeValue) || CssUtils.isMetricValue((String)attributeValue) || CssUtils.isRelativeValue((String)attributeValue)) && (unitsPosition = CssUtils.determinePositionBetweenValueAndUnit((String)attributeValue)) > 0) {
            absoluteValue = CssUtils.parseDouble((String)attributeValue.substring(0, unitsPosition));
        }
        return absoluteValue * 0.75;
    }

    private double getCoordinateForUserSpaceOnUse(String attributeName, double defaultValue, double start, double length, float em, float rem) {
        String attributeValue = this.getAttribute(attributeName);
        UnitValue unitValue = CssUtils.parseLengthValueToPt((String)attributeValue, (float)em, (float)rem);
        double absoluteValue = unitValue == null ? defaultValue : (unitValue.getUnitType() == 2 ? start + length * (double)unitValue.getValue() / 100.0 : (double)unitValue.getValue());
        return absoluteValue;
    }
}

