/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import java.util.HashMap;
import java.util.List;

public class RectangleSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    private float x = 0.0f;
    private float y = 0.0f;
    private float width;
    private float height;
    private boolean rxPresent = false;
    private boolean ryPresent = false;
    private float rx = 0.0f;
    private float ry = 0.0f;

    public RectangleSvgNodeRenderer() {
        this.attributesAndStyles = new HashMap();
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        boolean singleValuePresent;
        PdfCanvas cv = context.getCurrentCanvas();
        cv.writeLiteral("% rect\n");
        this.setParameters();
        boolean bl = singleValuePresent = this.rxPresent && !this.ryPresent || !this.rxPresent && this.ryPresent;
        if (!this.rxPresent && !this.ryPresent) {
            cv.rectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height);
        } else if (singleValuePresent) {
            cv.writeLiteral("% circle rounded rect\n");
            float radius = this.findCircularRadius(this.rx, this.ry, this.width, this.height);
            cv.roundRectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height, (double)radius);
        } else {
            cv.writeLiteral("% ellipse rounded rect\n");
            cv.moveTo((double)(this.x + this.rx), (double)this.y);
            cv.lineTo((double)(this.x + this.width - this.rx), (double)this.y);
            this.arc(this.x + this.width - 2.0f * this.rx, this.y, this.x + this.width, this.y + 2.0f * this.ry, -90.0f, 90.0f, cv);
            cv.lineTo((double)(this.x + this.width), (double)(this.y + this.height - this.ry));
            this.arc(this.x + this.width, this.y + this.height - 2.0f * this.ry, this.x + this.width - 2.0f * this.rx, this.y + this.height, 0.0f, 90.0f, cv);
            cv.lineTo((double)(this.x + this.rx), (double)(this.y + this.height));
            this.arc(this.x + 2.0f * this.rx, this.y + this.height, this.x, this.y + this.height - 2.0f * this.ry, 90.0f, 90.0f, cv);
            cv.lineTo((double)this.x, (double)(this.y + this.ry));
            this.arc(this.x, this.y + 2.0f * this.ry, this.x + 2.0f * this.rx, this.y, 180.0f, 90.0f, cv);
            cv.closePath();
        }
    }

    @Override
    protected Rectangle getObjectBoundingBox(SvgDrawContext context) {
        this.setParameters();
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    private void setParameters() {
        if (this.getAttribute("x") != null) {
            this.x = CssUtils.parseAbsoluteLength((String)this.getAttribute("x"));
        }
        if (this.getAttribute("y") != null) {
            this.y = CssUtils.parseAbsoluteLength((String)this.getAttribute("y"));
        }
        this.width = CssUtils.parseAbsoluteLength((String)this.getAttribute("width"));
        this.height = CssUtils.parseAbsoluteLength((String)this.getAttribute("height"));
        if (this.attributesAndStyles.containsKey("rx")) {
            this.rx = this.checkRadius(CssUtils.parseAbsoluteLength((String)this.getAttribute("rx")), this.width);
            this.rxPresent = true;
        }
        if (this.attributesAndStyles.containsKey("ry")) {
            this.ry = this.checkRadius(CssUtils.parseAbsoluteLength((String)this.getAttribute("ry")), this.height);
            this.ryPresent = true;
        }
    }

    private void arc(float x1, float y1, float x2, float y2, float startAng, float extent, PdfCanvas cv) {
        List ar = PdfCanvas.bezierArc((double)x1, (double)y1, (double)x2, (double)y2, (double)startAng, (double)extent);
        if (!ar.isEmpty()) {
            for (int k = 0; k < ar.size(); ++k) {
                double[] pt = (double[])ar.get(k);
                cv.curveTo(pt[2], pt[3], pt[4], pt[5], pt[6], pt[7]);
            }
        }
    }

    float checkRadius(float radius, float distance) {
        if (radius <= 0.0f) {
            return 0.0f;
        }
        if (radius > distance / 2.0f) {
            return distance / 2.0f;
        }
        return radius;
    }

    float findCircularRadius(float rx, float ry, float width, float height) {
        float maxRadius = Math.min(width, height) / 2.0f;
        float biggestRadius = Math.max(rx, ry);
        return Math.min(maxRadius, biggestRadius);
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        RectangleSvgNodeRenderer copy = new RectangleSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

