/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.filter.log;

import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.response.Cookie;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.FilterableResponseSpecification;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestLoggingFilter
implements Filter {
    private static final String TAB = "\t";
    private static final String NEW_LINE = "\n";
    private static final String EQUALS = "=";
    private static final String NONE = "<none>";
    private static final String CONTENT_TYPE = "Content-Type";
    private final LogDetail logDetail;
    private final PrintStream stream;

    public RequestLoggingFilter() {
        this(LogDetail.ALL, System.out);
    }

    public RequestLoggingFilter(LogDetail logDetail) {
        this(logDetail, System.out);
    }

    public RequestLoggingFilter(PrintStream printStream) {
        this(LogDetail.ALL, printStream);
    }

    public RequestLoggingFilter(LogDetail logDetail, PrintStream stream) {
        Validate.notNull((Object)stream, (String)"Print stream cannot be null");
        Validate.notNull((Object)((Object)logDetail), (String)"Log details cannot be null");
        if (logDetail == LogDetail.STATUS) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s for a request.", new Object[]{LogDetail.STATUS, LogDetail.class.getSimpleName()}));
        }
        this.stream = stream;
        this.logDetail = logDetail;
    }

    @Override
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        String logString;
        StringBuilder builder = new StringBuilder();
        if (this.logDetail == LogDetail.ALL) {
            this.addSingle(builder, "Request method:", ctx.getRequestMethod().toString());
            this.addSingle(builder, "Request path:", ctx.getRequestPath());
        }
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.PARAMS) {
            this.addMapDetails(builder, "Request params:", requestSpec.getRequestParams());
            this.addMapDetails(builder, "Query params:", requestSpec.getQueryParams());
            this.addMapDetails(builder, "Form params:", requestSpec.getFormParams());
            this.addMapDetails(builder, "Path params:", requestSpec.getPathParams());
        }
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.HEADERS) {
            this.addHeaders(requestSpec, builder);
        }
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.COOKIES) {
            this.addCookies(requestSpec, builder);
        }
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.BODY) {
            this.addBody(requestSpec, builder);
        }
        if ((logString = builder.toString()).endsWith(NEW_LINE)) {
            logString = StringUtils.removeEnd((String)logString, (String)NEW_LINE);
        }
        this.stream.println(logString);
        return ctx.next(requestSpec, responseSpec);
    }

    private void addBody(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Body:");
        if (requestSpec.getBody() != null) {
            builder.append(NEW_LINE).append(requestSpec.getBody());
        } else {
            this.appendTab(this.appendTwoTabs(builder)).append(NONE);
        }
    }

    private void addCookies(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Cookies:");
        Cookies cookies = requestSpec.getCookies();
        if (!cookies.exist()) {
            this.appendTwoTabs(builder).append(NONE).append(NEW_LINE);
        }
        int i = 0;
        for (Cookie cookie : cookies) {
            if (i++ == 0) {
                this.appendTwoTabs(builder);
            } else {
                this.appendFourTabs(builder);
            }
            builder.append(cookie).append(NEW_LINE);
        }
    }

    private void addHeaders(FilterableRequestSpecification requestSpec, StringBuilder builder) {
        builder.append("Headers:");
        Headers headers = requestSpec.getHeaders();
        boolean hasContentTypeHeader = headers.hasHeaderWithName(CONTENT_TYPE);
        if (!hasContentTypeHeader) {
            this.appendTwoTabs(builder);
            builder.append(CONTENT_TYPE).append(EQUALS).append(requestSpec.getRequestContentType()).append(NEW_LINE);
        }
        int i = 0;
        for (Header header : headers) {
            if (i++ == 0 && hasContentTypeHeader) {
                this.appendTwoTabs(builder);
            } else {
                this.appendFourTabs(builder);
            }
            builder.append(header).append(NEW_LINE);
        }
    }

    private void addSingle(StringBuilder builder, String str, String requestPath) {
        this.appendTab(builder.append(str)).append(requestPath).append(NEW_LINE);
    }

    private void addMapDetails(StringBuilder builder, String title, Map<String, ?> map) {
        this.appendTab(builder.append(title));
        if (map.isEmpty()) {
            builder.append(NONE).append(NEW_LINE);
        } else {
            int i = 0;
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (i++ != 0) {
                    this.appendFourTabs(builder);
                }
                builder.append(entry.getKey()).append(EQUALS).append(entry.getValue()).append(NEW_LINE);
            }
        }
    }

    private StringBuilder appendFourTabs(StringBuilder builder) {
        this.appendTwoTabs(this.appendTwoTabs(builder));
        return builder;
    }

    private StringBuilder appendTwoTabs(StringBuilder builder) {
        this.appendTab(this.appendTab(builder));
        return builder;
    }

    private StringBuilder appendTab(StringBuilder builder) {
        return builder.append(TAB);
    }
}

