/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.assertion.AssertParameter;
import com.jayway.restassured.config.HttpClientConfig;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.RedirectConfig;

public class RestAssuredConfig {
    private final RedirectConfig redirectConfig;
    private final HttpClientConfig httpClientConfig;
    private final LogConfig logConfig;

    public RestAssuredConfig() {
        this(new RedirectConfig(), new HttpClientConfig(), new LogConfig());
    }

    public RestAssuredConfig(RedirectConfig redirectConfig, HttpClientConfig httpClientConfig, LogConfig logConfig) {
        AssertParameter.notNull(redirectConfig, "Redirect Config");
        AssertParameter.notNull(httpClientConfig, "HTTP Client Config");
        AssertParameter.notNull(logConfig, "Log config");
        this.httpClientConfig = httpClientConfig;
        this.redirectConfig = redirectConfig;
        this.logConfig = logConfig;
    }

    public RestAssuredConfig redirect(RedirectConfig redirectConfig) {
        AssertParameter.notNull(redirectConfig, "Redirect config");
        return new RestAssuredConfig(redirectConfig, this.httpClientConfig, this.logConfig);
    }

    public RestAssuredConfig httpClient(HttpClientConfig httpClientConfig) {
        AssertParameter.notNull(httpClientConfig, "HTTP Client Config");
        return new RestAssuredConfig(this.redirectConfig, httpClientConfig, this.logConfig);
    }

    public RestAssuredConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull(logConfig, "Log config");
        return new RestAssuredConfig(this.redirectConfig, this.httpClientConfig, logConfig);
    }

    public RestAssuredConfig and() {
        return this;
    }

    public RestAssuredConfig set() {
        return this;
    }

    public RedirectConfig getRedirectConfig() {
        return this.redirectConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public static RestAssuredConfig newConfig() {
        return new RestAssuredConfig();
    }

    public static RestAssuredConfig config() {
        return new RestAssuredConfig();
    }
}

