/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.maven.plugin;

import com.google.common.io.Files;
import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodCacher;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.log.Logger;
import com.jcabi.maven.plugin.AjcMojo$AjcClosure1;
import com.jcabi.maven.plugin.AjcMojo$AjcClosure11;
import com.jcabi.maven.plugin.AjcMojo$AjcClosure3;
import com.jcabi.maven.plugin.AjcMojo$AjcClosure5;
import com.jcabi.maven.plugin.AjcMojo$AjcClosure7;
import com.jcabi.maven.plugin.AjcMojo$AjcClosure9;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.tools.ajc.Main;
import org.slf4j.impl.StaticLoggerBinder;

@Loggable(value=1)
@Mojo(name="ajc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class AjcMojo
extends AbstractMojo {
    private static final String SEP;
    @Component
    private transient MavenProject project;
    @Parameter(required=false, readonly=false, defaultValue="${project.build.outputDirectory}")
    private transient File classesDirectory;
    @Parameter(required=false, readonly=false, defaultValue="${project.build.outputDirectory}")
    private transient File unwovenClassesDir;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private transient File outputDirectory;
    @Parameter(required=false, readonly=false)
    private transient File[] aspectDirectories;
    @Parameter(defaultValue="${project.build.directory}/jcabi-ajc", required=false, readonly=false)
    private transient File tempDirectory;
    @Parameter(required=false, readonly=false, property="source", defaultValue="1.6")
    private transient String source;
    @Parameter(required=false, readonly=false, property="target", defaultValue="1.6")
    private transient String target;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private transient List<String> classpathElements;
    @Parameter(required=false, readonly=false, property="log", defaultValue="${project.build.directory}/jcabi-ajc.log")
    private transient String log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Loggable(value=1, limit=1, unit=TimeUnit.MINUTES)
    public void execute() throws MojoFailureException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodLogger.aspectOf().wrapClass(new AjcMojo$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AjcMojo.execute_aroundBody2(this, joinPoint);
    }

    private void executeAJC() throws MojoFailureException {
        if (this.tempDirectory.mkdirs()) {
            Logger.info((Object)((Object)this), (String)"Created temp dir %s", (Object[])new Object[]{this.tempDirectory});
        }
        Main main = new Main();
        MsgHolder mholder = new MsgHolder();
        main.run(new String[]{"-Xset:avoidFinal=true", "-Xlint:warning", "-inpath", this.classesDirectory.getAbsolutePath(), "-sourceroots", this.sourceroots(), "-d", this.tempDirectory.getAbsolutePath(), "-classpath", StringUtils.join(this.classpath(), (String)SEP), "-aspectpath", this.aspectpath(), "-source", this.source, "-target", this.target, "-g:none", "-encoding", "UTF-8", "-time", "-log", this.log, "-showWeaveInfo", "-warn:constructorName", "-warn:packageDefaultMethod", "-warn:deprecation", "-warn:maskedCatchBlocks", "-warn:unusedLocals", "-warn:unusedArguments", "-warn:unusedImports", "-warn:syntheticAccess", "-warn:assertIdentifier"}, (IMessageHolder)mholder);
        try {
            FileUtils.copyDirectory((File)this.tempDirectory, (File)this.classesDirectory);
            FileUtils.cleanDirectory((File)this.tempDirectory);
        }
        catch (IOException ex) {
            throw new MojoFailureException("failed to copy files and clean temp", (Throwable)ex);
        }
        Logger.info((Object)((Object)this), (String)"ajc result: %d file(s) processed, %d pointcut(s) woven, %d error(s), %d warning(s)", (Object[])new Object[]{AjcMojo.files(this.classesDirectory).size(), mholder.numMessages(IMessage.WEAVEINFO, false), mholder.numMessages(IMessage.ERROR, true), mholder.numMessages(IMessage.WARNING, false)});
        if (mholder.hasAnyMessage(IMessage.ERROR, true)) {
            throw new MojoFailureException("AJC failed, see log above");
        }
    }

    @Cacheable(forever=true)
    @Loggable(value=1, limit=1, unit=TimeUnit.MINUTES, trim=false)
    private Collection<String> classpath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)MethodCacher.aspectOf().cache(new AjcMojo$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Cacheable(forever=true)
    private String aspectpath() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)MethodCacher.aspectOf().cache(new AjcMojo$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Cacheable(forever=true)
    private String sourceroots() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)MethodCacher.aspectOf().cache(new AjcMojo$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean hasClasses() {
        return this.listClasses().size() > 0;
    }

    private Collection<File> listClasses() {
        IOFileFilter classesFilter = FileFilterUtils.suffixFileFilter((String)".class");
        return FileUtils.listFiles((File)this.classesDirectory, (IOFileFilter)classesFilter, (IOFileFilter)FileFilterUtils.directoryFileFilter());
    }

    private boolean hasSourceroots() {
        return this.aspectDirectories != null && this.aspectDirectories.length > 0;
    }

    private static Collection<File> files(File dir) {
        LinkedList<File> files = new LinkedList<File>();
        Collection all = FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File file : all) {
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private void copyUnwovenClasses() throws MojoFailureException {
        this.unwovenClassesDir.mkdirs();
        Logger.info((Object)((Object)this), (String)"Unwoven classes will be copied to %s", (Object[])new Object[]{this.unwovenClassesDir});
        if (this.hasClasses()) {
            try {
                this.copyClasses(this.unwovenClassesDir);
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Exception when copying unwoven classes to %s: %s", this.unwovenClassesDir, ex.getMessage()), (Throwable)ex);
            }
        } else {
            Logger.warn((Object)((Object)this), (String)"No classes found at %s. Nothing will be copied to %s", (Object[])new Object[]{this.classesDirectory, this.unwovenClassesDir});
        }
    }

    private void copyClasses(File dir) throws IOException {
        FileUtils.cleanDirectory((File)dir);
        FileUtils.copyDirectory((File)this.classesDirectory, (File)dir, (boolean)false);
    }

    public String toString() {
        return "AjcMojo(project=" + this.project + ", classesDirectory=" + this.classesDirectory + ", unwovenClassesDir=" + this.unwovenClassesDir + ", outputDirectory=" + this.outputDirectory + ", aspectDirectories=" + Arrays.deepToString(this.aspectDirectories) + ", tempDirectory=" + this.tempDirectory + ", source=" + this.source + ", target=" + this.target + ", classpathElements=" + this.classpathElements + ", log=" + this.log + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AjcMojo)) {
            return false;
        }
        AjcMojo other = (AjcMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MavenProject this$project = this.project;
        MavenProject other$project = other.project;
        return !(this$project == null ? other$project != null : !this$project.equals(other$project));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AjcMojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MavenProject $project = this.project;
        result = result * 59 + ($project == null ? 0 : $project.hashCode());
        return result;
    }

    static {
        AjcMojo.ajc$preClinit();
        SEP = System.getProperty("path.separator");
    }

    static /* synthetic */ void execute_aroundBody0(AjcMojo ajc$this, JoinPoint joinPoint) {
        StaticLoggerBinder.getSingleton().setMavenLog(ajc$this.getLog());
        ArtifactHandler artifactHandler = ajc$this.project.getArtifact().getArtifactHandler();
        if (!"java".equalsIgnoreCase(artifactHandler.getLanguage())) {
            Logger.warn((Object)((Object)ajc$this), (String)"Not executing AJC as the project is not a Java classpath-capable package");
            return;
        }
        if (ajc$this.classesDirectory.mkdirs()) {
            Logger.info((Object)((Object)ajc$this), (String)"Created classes dir %s", (Object[])new Object[]{ajc$this.classesDirectory});
        }
        if (!ajc$this.unwovenClassesDir.equals(ajc$this.outputDirectory) && !ajc$this.unwovenClassesDir.equals(ajc$this.classesDirectory)) {
            ajc$this.copyUnwovenClasses();
        }
        if (ajc$this.hasClasses() || ajc$this.hasSourceroots()) {
            ajc$this.executeAJC();
        } else {
            Logger.warn((Object)((Object)ajc$this), (String)"Not executing AJC as there is no .class file or source roots file.");
        }
    }

    static /* synthetic */ void execute_aroundBody2(AjcMojo ajcMojo, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{ajcMojo, joinPoint};
        MethodLogger.aspectOf().wrapMethod(new AjcMojo$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    static /* synthetic */ Collection classpath_aroundBody4(AjcMojo ajc$this, JoinPoint joinPoint) {
        return ajc$this.classpathElements;
    }

    static /* synthetic */ Collection classpath_aroundBody6(AjcMojo ajcMojo, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{ajcMojo, joinPoint};
        return (Collection)MethodLogger.aspectOf().wrapMethod(new AjcMojo$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    static /* synthetic */ String aspectpath_aroundBody8(AjcMojo ajc$this, JoinPoint joinPoint) {
        return new StringBuilder(0).append(StringUtils.join(ajc$this.classpath(), (String)SEP)).append(SEP).append(System.getProperty("java.class.path")).toString();
    }

    static /* synthetic */ String sourceroots_aroundBody10(AjcMojo ajc$this, JoinPoint joinPoint) {
        String path;
        if (ajc$this.aspectDirectories == null || ajc$this.aspectDirectories.length == 0) {
            path = Files.createTempDir().getAbsolutePath();
        } else {
            for (File dir : ajc$this.aspectDirectories) {
                if (dir.exists()) continue;
                throw new IllegalStateException(String.format("source directory %s is absent", dir));
            }
            path = StringUtils.join((Object[])ajc$this.aspectDirectories, (String)SEP);
        }
        return path;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AjcMojo.java", AjcMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.jcabi.maven.plugin.AjcMojo", "", "", "org.apache.maven.plugin.MojoFailureException", "void"), 200);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "classpath", "com.jcabi.maven.plugin.AjcMojo", "", "", "", "java.util.Collection"), 311);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "aspectpath", "com.jcabi.maven.plugin.AjcMojo", "", "", "", "java.lang.String"), 320);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sourceroots", "com.jcabi.maven.plugin.AjcMojo", "", "", "", "java.lang.String"), 334);
    }

    private static final class MsgHolder
    implements IMessageHolder {
        private final transient Collection<IMessage> messages = new CopyOnWriteArrayList<IMessage>();

        private MsgHolder() {
        }

        public boolean hasAnyMessage(IMessage.Kind kind, boolean greater) {
            IMessage msg;
            boolean has = false;
            Iterator<IMessage> i$ = this.messages.iterator();
            while (i$.hasNext() && !(has = (msg = i$.next()).getKind().equals(kind) || greater && IMessage.Kind.COMPARATOR.compare(msg.getKind(), kind) > 0)) {
            }
            return has;
        }

        public int numMessages(IMessage.Kind kind, boolean greater) {
            int num = 0;
            for (IMessage msg : this.messages) {
                boolean has = msg.getKind().equals(kind) || greater && IMessage.Kind.COMPARATOR.compare(msg.getKind(), kind) > 0;
                if (!has) continue;
                ++num;
            }
            return num;
        }

        public IMessage[] getMessages(IMessage.Kind kind, boolean greater) {
            throw new UnsupportedOperationException();
        }

        public List<IMessage> getUnmodifiableListView() {
            throw new UnsupportedOperationException();
        }

        public void clearMessages() {
            throw new UnsupportedOperationException();
        }

        public boolean handleMessage(IMessage msg) {
            if (msg.getKind().equals(IMessage.ERROR) || msg.getKind().equals(IMessage.FAIL) || msg.getKind().equals(IMessage.ABORT)) {
                Logger.error(AjcMojo.class, (String)msg.getMessage());
            } else if (msg.getKind().equals(IMessage.WARNING)) {
                Logger.warn(AjcMojo.class, (String)msg.getMessage());
            } else {
                Logger.debug(AjcMojo.class, (String)msg.getMessage());
            }
            this.messages.add(msg);
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return false;
        }

        public void dontIgnore(IMessage.Kind kind) {
            assert (kind != null);
        }

        public void ignore(IMessage.Kind kind) {
            assert (kind != null);
        }
    }
}

