/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.maven.plugin;

import com.jcabi.log.Logger;
import com.jcabi.maven.plugin.UnwovenClasses;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.tools.ajc.Main;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="ajc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class AjcMojo
extends AbstractMojo
implements Contextualizable {
    private static final String SEP = System.getProperty("path.separator");
    @Parameter(defaultValue="${project}", readonly=true)
    private transient MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private transient MojoExecution execution;
    @Parameter(defaultValue="${session}", readonly=true)
    private transient MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private transient RepositorySystemSession rsession;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private transient File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/unwoven")
    private transient File unwovenClassesDir;
    @Parameter(defaultValue="false")
    private transient boolean disableCopy;
    @Parameter
    private transient File[] aspectDirectories;
    @Parameter(defaultValue="${project.build.directory}/jcabi-ajc")
    private transient File tempDirectory;
    @Parameter
    private transient String[] scopes;
    private transient PlexusContainer container;
    @Parameter(property="source", defaultValue="1.8")
    private transient String source;
    @Parameter(property="target", defaultValue="1.8")
    private transient String target;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private transient List<String> classpathElements;
    @Parameter(property="log", defaultValue="${project.build.directory}/jcabi-ajc.log")
    private transient String log;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        ArtifactHandler handler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equalsIgnoreCase(handler.getLanguage())) {
            Logger.warn((Object)((Object)this), (String)"Not executing AJC as the project is not a Java classpath-capable package");
            return;
        }
        if (this.classesDirectory.mkdirs()) {
            Logger.info((Object)((Object)this), (String)"Created classes dir %s", (Object[])new Object[]{this.classesDirectory});
        }
        if (!this.disableCopy && !this.unwovenClassesDir.equals(this.classesDirectory)) {
            this.copyUnwovenClasses();
        }
        if (this.hasClasses() || this.hasSourceroots()) {
            try {
                this.executeAjc();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            Logger.warn((Object)((Object)this), (String)"Not executing AJC as there is no .class file or source roots file.");
        }
    }

    private void executeAjc() throws MojoFailureException, IOException {
        if (this.tempDirectory.mkdirs()) {
            Logger.info((Object)((Object)this), (String)"Created temp dir %s", (Object[])new Object[]{this.tempDirectory});
        }
        Main main = new Main();
        MsgHolder mholder = new MsgHolder();
        main.run(new String[]{"-Xset:avoidFinal=true", "-Xlint:warning", "-inpath", this.classesDirectory.getAbsolutePath(), "-sourceroots", this.sourceroots(), "-d", this.tempDirectory.getAbsolutePath(), "-classpath", StringUtils.join(this.classpath(), (String)SEP), "-aspectpath", this.aspectpath(), "-source", this.source, "-target", this.target, "-g:none", "-encoding", "UTF-8", "-time", "-log", this.log, "-showWeaveInfo", "-warn:constructorName", "-warn:packageDefaultMethod", "-warn:deprecation", "-warn:maskedCatchBlocks", "-warn:unusedLocals", "-warn:unusedArguments", "-warn:unusedImports", "-warn:syntheticAccess", "-warn:assertIdentifier"}, (IMessageHolder)mholder);
        try {
            FileUtils.copyDirectory((File)this.tempDirectory, (File)this.classesDirectory);
            FileUtils.cleanDirectory((File)this.tempDirectory);
        }
        catch (IOException ex) {
            throw new MojoFailureException("failed to copy files and clean temp", (Throwable)ex);
        }
        Logger.info((Object)((Object)this), (String)"ajc result: %d file(s) processed, %d pointcut(s) woven, %d error(s), %d warning(s)", (Object[])new Object[]{AjcMojo.files(this.classesDirectory).size(), mholder.numMessages(IMessage.WEAVEINFO, false), mholder.numMessages(IMessage.ERROR, true), mholder.numMessages(IMessage.WARNING, false)});
        if (mholder.hasAnyMessage(IMessage.ERROR, true)) {
            throw new MojoFailureException("AJC failed, see log above");
        }
    }

    private Collection<String> classpath() {
        Collection<String> scps = this.scopes == null ? AjcMojo.scope() : Arrays.asList(this.scopes);
        LinkedList<String> elements = new LinkedList<String>();
        try {
            DependencyGraphBuilder builder = (DependencyGraphBuilder)DependencyGraphBuilder.class.cast(this.container.lookup(DependencyGraphBuilder.class.getCanonicalName(), "default"));
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            request.setProject(this.project);
            request.setRepositorySession(this.rsession);
            DependencyNode node = builder.buildDependencyGraph((ProjectBuildingRequest)request, artifact -> scps.contains(artifact.getScope()));
            elements.addAll(this.dependencies(node, scps));
        }
        catch (DependencyGraphBuilderException | ComponentLookupException ex) {
            throw new IllegalStateException(ex);
        }
        elements.addAll(this.classpathElements);
        return elements;
    }

    private Collection<String> dependencies(DependencyNode node, Collection<String> scps) {
        Artifact artifact = node.getArtifact();
        LinkedList<String> files = new LinkedList<String>();
        if (artifact.getScope() == null || scps.contains(artifact.getScope())) {
            if (artifact.getScope() == null) {
                files.add(artifact.getFile().toString());
            } else {
                files.add(this.session.getLocalRepository().find(artifact).getFile().toString());
            }
            for (DependencyNode child : node.getChildren()) {
                if (child.getArtifact().compareTo((Object)node.getArtifact()) == 0) continue;
                files.addAll(this.dependencies(child, scps));
            }
        }
        return files;
    }

    private static Collection<String> scope() {
        List<String> scps = AjcMojo.eclipseAether() ? Arrays.asList("compile", "provided", "runtime", "system") : Arrays.asList("compile", "runtime", "provided", "system");
        return scps;
    }

    private static boolean eclipseAether() {
        boolean found = false;
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.sonatype.aether.graph.DependencyFilter");
        }
        catch (ClassNotFoundException ex) {
            found = true;
        }
        return found;
    }

    private String aspectpath() {
        return new StringBuilder(0).append(StringUtils.join(this.classpath(), (String)SEP)).append(SEP).append(System.getProperty("java.class.path")).toString();
    }

    private String sourceroots() throws IOException {
        String path;
        if (this.aspectDirectories == null || this.aspectDirectories.length == 0) {
            path = Files.createTempDirectory("temp", new FileAttribute[0]).toAbsolutePath().toString();
        } else {
            for (File dir : this.aspectDirectories) {
                if (dir.exists()) continue;
                throw new IllegalStateException(String.format("source directory %s is absent", dir));
            }
            path = StringUtils.join((Object[])this.aspectDirectories, (String)SEP);
        }
        return path;
    }

    private boolean hasClasses() {
        return this.listClasses().size() > 0;
    }

    private Collection<File> listClasses() {
        IOFileFilter filter = FileFilterUtils.suffixFileFilter((String)".class");
        return FileUtils.listFiles((File)this.classesDirectory, (IOFileFilter)filter, (IOFileFilter)FileFilterUtils.directoryFileFilter());
    }

    private boolean hasSourceroots() {
        return this.aspectDirectories != null && this.aspectDirectories.length > 0;
    }

    private static Collection<File> files(File dir) {
        LinkedList<File> files = new LinkedList<File>();
        Collection all = FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File file : all) {
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private void copyUnwovenClasses() throws MojoFailureException {
        if (this.hasClasses()) {
            new UnwovenClasses(this.unwovenClassesDir, this.classesDirectory, this.execution.getLifecyclePhase()).copy();
        } else {
            Logger.warn((Object)((Object)this), (String)"No classes found at %s. Nothing will be copied to %s", (Object[])new Object[]{this.classesDirectory, this.unwovenClassesDir});
        }
    }

    private static final class MsgHolder
    implements IMessageHolder {
        private final transient Collection<IMessage> messages = new CopyOnWriteArrayList<IMessage>();

        private MsgHolder() {
        }

        public boolean hasAnyMessage(IMessage.Kind kind, boolean greater) {
            IMessage msg;
            boolean has = false;
            Iterator<IMessage> iterator = this.messages.iterator();
            while (iterator.hasNext() && !(has = (msg = iterator.next()).getKind().equals(kind) || greater && IMessage.Kind.COMPARATOR.compare(msg.getKind(), kind) > 0)) {
            }
            return has;
        }

        public int numMessages(IMessage.Kind kind, boolean greater) {
            int num = 0;
            for (IMessage msg : this.messages) {
                boolean has = msg.getKind().equals(kind) || greater && IMessage.Kind.COMPARATOR.compare(msg.getKind(), kind) > 0;
                if (!has) continue;
                ++num;
            }
            return num;
        }

        public IMessage[] getMessages(IMessage.Kind kind, boolean greater) {
            throw new UnsupportedOperationException();
        }

        public List<IMessage> getUnmodifiableListView() {
            throw new UnsupportedOperationException();
        }

        public void clearMessages() {
            throw new UnsupportedOperationException();
        }

        public boolean handleMessage(IMessage msg) {
            if (msg.getKind().equals(IMessage.ERROR) || msg.getKind().equals(IMessage.FAIL) || msg.getKind().equals(IMessage.ABORT)) {
                Logger.error(AjcMojo.class, (String)msg.getMessage());
            } else if (msg.getKind().equals(IMessage.WARNING)) {
                Logger.warn(AjcMojo.class, (String)msg.getMessage());
            } else {
                Logger.debug(AjcMojo.class, (String)msg.getMessage());
            }
            this.messages.add(msg);
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return false;
        }

        public void dontIgnore(IMessage.Kind kind) {
            assert (kind != null);
        }

        public void ignore(IMessage.Kind kind) {
            assert (kind != null);
        }
    }
}

