/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public final class ImageProcessor {
    private static ImageProcessor imageProcessor = new ImageProcessor();

    private ImageProcessor() {
    }

    public static ImageProcessor getInstance() {
        return imageProcessor;
    }

    public static InputStream readImage(String fileName, int width, int height, String imageType) throws IOException {
        BufferedImage originImage = ImageIO.read(ImageProcessor.getInputStream(fileName));
        Image scaledImage = originImage.getScaledInstance(width, height, 4);
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(scaledImage, 0, 0, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, imageType, outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private static InputStream getInputStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }
}

