/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.bg;

import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.collide.RectanglePixelCollidable;
import com.kennycason.kumo.image.CollisionRaster;
import java.awt.Dimension;
import java.awt.Point;

public class RectangleBackground
implements Background {
    private static final Point ZERO = new Point(0, 0);
    private final Point position;
    private final Dimension dimension;

    public RectangleBackground(Dimension dimension) {
        this(ZERO, dimension);
    }

    public RectangleBackground(Point position, Dimension dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    @Override
    public void mask(RectanglePixelCollidable background) {
        Dimension dimensionOfShape = this.dimension;
        int minY = Math.max(this.position.y, 0);
        int minX = Math.max(this.position.x, 0);
        int maxY = dimensionOfShape.height + this.position.y - 1;
        int maxX = dimensionOfShape.width + this.position.x - 1;
        Dimension dimensionOfBackground = background.getDimension();
        CollisionRaster rasterOfBackground = background.getCollisionRaster();
        for (int y = 0; y < dimensionOfBackground.height; ++y) {
            for (int x = 0; x < dimensionOfBackground.width; ++x) {
                if (y >= minY && y <= maxY && x >= minX && x <= maxX) continue;
                rasterOfBackground.setPixelIsNotTransparent(x, y);
            }
        }
    }

    public String toString() {
        return "RectangleBackground [x=" + this.position.x + ", y=" + this.position.y + ", width=" + this.dimension.width + ", height=" + this.dimension.height + "]";
    }
}

