/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.BitSet;

public class CollisionRaster {
    private final BitSet data;
    private final Dimension dimension;

    public CollisionRaster(BufferedImage bufferedImage) {
        this(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
        for (int y = 0; y < this.dimension.height; ++y) {
            for (int x = 0; x < this.dimension.width; ++x) {
                boolean pixelIsTransparent;
                boolean bl = pixelIsTransparent = (bufferedImage.getRGB(x, y) & 0xFF000000) == 0;
                if (pixelIsTransparent) continue;
                this.setPixelIsNotTransparent(x, y);
            }
        }
    }

    public CollisionRaster(Dimension dimension) {
        this.dimension = dimension;
        this.data = new BitSet(dimension.width * dimension.height);
    }

    public CollisionRaster(CollisionRaster other) {
        this.dimension = other.dimension;
        this.data = (BitSet)other.data.clone();
    }

    private int computeIndex(int x, int y) {
        if (x < 0 || x >= this.dimension.width) {
            throw new IllegalArgumentException("x is out of bounds");
        }
        if (y < 0 || y >= this.dimension.height) {
            throw new IllegalArgumentException("y is out of bounds");
        }
        return y * this.dimension.width + x;
    }

    public final void setPixelIsNotTransparent(int x, int y) {
        this.data.set(this.computeIndex(x, y));
    }

    public void mask(CollisionRaster collisionRaster, Point point) {
        int maxHeight = Math.min(point.y + collisionRaster.getDimension().height, this.dimension.height);
        int maxWidth = Math.min(point.x + collisionRaster.getDimension().width, this.dimension.width);
        int offY = point.y;
        int offY2 = 0;
        while (offY < maxHeight) {
            int offX = point.x;
            int offX2 = 0;
            while (offX < maxWidth) {
                if (!collisionRaster.isTransparent(offX2, offY2)) {
                    this.setPixelIsNotTransparent(offX, offY);
                }
                ++offX;
                ++offX2;
            }
            ++offY;
            ++offY2;
        }
    }

    public int nextNotTransparentPixel(int minX, int maxX, int y) {
        if (maxX > this.dimension.width) {
            throw new IllegalArgumentException("maxX is out of bounds");
        }
        int idx = this.computeIndex(minX, y);
        int set = this.data.nextSetBit(idx);
        if (set != -1 && set < idx + maxX - minX) {
            return set - idx + minX;
        }
        return -1;
    }

    public boolean isTransparent(int x, int y) {
        return !this.data.get(this.computeIndex(x, y));
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

