/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.nlp;

import com.kennycason.kumo.WordFrequency;
import com.kennycason.kumo.exception.KumoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class FrequencyFileLoader {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_ERROR_MESSAGE = "Frequency File format is: <frequency_count>: <word>. E.g. 100: foo";

    public List<WordFrequency> load(File file) throws IOException {
        return this.load(new FileInputStream(file));
    }

    public List<WordFrequency> load(InputStream inputStream) throws IOException {
        return FrequencyFileLoader.processLines(IOUtils.readLines((InputStream)inputStream, (String)DEFAULT_ENCODING));
    }

    private static List<WordFrequency> processLines(List<String> lines) {
        return lines.stream().filter(StringUtils::isNotBlank).map(FrequencyFileLoader::buildWordFrequency).sorted(WordFrequency::compareTo).collect(Collectors.toList());
    }

    private static WordFrequency buildWordFrequency(String line) {
        if (line.isEmpty()) {
            throw new KumoException("Encountered an empty line in file. Frequency File format is: <frequency_count>: <word>. E.g. 100: foo");
        }
        if (!line.contains(":")) {
            throw new KumoException("Unable to process line: [" + line + "]. " + DEFAULT_ERROR_MESSAGE);
        }
        String[] parts = line.split(":");
        if (parts.length != 2) {
            throw new KumoException("Unable to process line: [" + line + "]. " + DEFAULT_ERROR_MESSAGE);
        }
        int wordCount = NumberUtils.toInt((String)StringUtils.trimToNull((String)parts[0]), (int)0);
        if (wordCount <= 0) {
            throw new KumoException("Word frequency must be a valid number > 0. Frequency File format is: <frequency_count>: <word>. E.g. 100: foo");
        }
        String word = StringUtils.trimToNull((String)parts[1]);
        if (word == null) {
            throw new KumoException("Word must not be blank Frequency File format is: <frequency_count>: <word>. E.g. 100: foo");
        }
        return new WordFrequency(word, wordCount);
    }
}

