/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.padding;

import com.kennycason.kumo.Word;
import com.kennycason.kumo.image.CollisionRaster;
import com.kennycason.kumo.padding.Padder;
import com.kennycason.kumo.padding.RectanglePadder;

public class WordPixelPadder
implements Padder {
    private RectanglePadder rectanglePadder = new RectanglePadder();

    @Override
    public void pad(Word word, int padding) {
        if (padding <= 0) {
            return;
        }
        this.rectanglePadder.pad(word, padding);
        CollisionRaster collisionRaster = word.getCollisionRaster();
        CollisionRaster originalRaster = new CollisionRaster(collisionRaster);
        int width = originalRaster.getDimension().width;
        int height = originalRaster.getDimension().height;
        int[] pixelsSetInPaddingPerColumn = new int[width];
        for (int x = 0; x < width; ++x) {
            pixelsSetInPaddingPerColumn[x] = this.countNotTransparentPixels(originalRaster, 0, Math.min(padding, height - 1), x);
        }
        for (int y = 0; y < height; ++y) {
            int x;
            int set;
            int line;
            if (y - padding >= 0) {
                line = y - padding;
                set = -1;
                while ((set = originalRaster.nextNotTransparentPixel(set + 1, width, line)) != -1) {
                    int n = set;
                    pixelsSetInPaddingPerColumn[n] = pixelsSetInPaddingPerColumn[n] - 1;
                }
            }
            if (y > 0 && y + padding < height) {
                line = y + padding;
                set = -1;
                while ((set = originalRaster.nextNotTransparentPixel(set + 1, width, line)) != -1) {
                    int n = set;
                    pixelsSetInPaddingPerColumn[n] = pixelsSetInPaddingPerColumn[n] + 1;
                }
            }
            int pixelsSetInPaddingArea = 0;
            int n = Math.min(padding, width - 1);
            for (x = 0; x < n; ++x) {
                pixelsSetInPaddingArea += pixelsSetInPaddingPerColumn[x];
            }
            for (x = 0; x < width; ++x) {
                if (x - padding >= 0) {
                    pixelsSetInPaddingArea -= pixelsSetInPaddingPerColumn[x - padding];
                }
                if (x > 0 && x + padding < width) {
                    pixelsSetInPaddingArea += pixelsSetInPaddingPerColumn[x + padding];
                }
                if (pixelsSetInPaddingArea <= 0) continue;
                collisionRaster.setPixelIsNotTransparent(x, y);
            }
        }
    }

    private int countNotTransparentPixels(CollisionRaster originalRaster, int minY, int maxY, int x) {
        int n = 0;
        for (int y = minY; y <= maxY; ++y) {
            if (originalRaster.isTransparent(x, y)) continue;
            ++n;
        }
        return n;
    }
}

