/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import kong.unirest.AsyncClient;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.MetricContext;
import kong.unirest.RawResponse;
import kong.unirest.UnirestException;
import kong.unirest.apache.ApacheAsyncConfig;
import kong.unirest.apache.ApacheResponse;
import kong.unirest.apache.AsyncIdleConnectionMonitorThread;
import kong.unirest.apache.BaseApacheClient;
import kong.unirest.apache.RequestConfigFactory;
import kong.unirest.apache.RequestPrep;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

public class ApacheAsyncClient
extends BaseApacheClient
implements AsyncClient {
    private ApacheAsyncConfig apache;

    public ApacheAsyncClient(Config config) {
        this.apache = new ApacheAsyncConfig(config);
    }

    public ApacheAsyncClient(HttpAsyncClient client, Config config) {
        this.apache = new ApacheAsyncConfig(client, config);
    }

    @Deprecated
    public ApacheAsyncClient(HttpAsyncClient client, Config config, PoolingNHttpClientConnectionManager manager, AsyncIdleConnectionMonitorThread monitor) {
        this.apache = new ApacheAsyncConfig(client, config, manager, monitor);
    }

    @Override
    public void registerShutdownHook() {
        this.apache.registerShutdownHook();
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, final Function<RawResponse, HttpResponse<T>> transformer, final CompletableFuture<HttpResponse<T>> callback) {
        Objects.requireNonNull(callback);
        this.apache.config.getUniInterceptor().onRequest(request, this.apache.config);
        HttpRequestBase requestObj = new RequestPrep(request, this.apache.config, true).prepare(this.configFactory);
        final HttpRequestSummary reqSum = request.toSummary();
        final MetricContext metric = this.apache.config.getMetric().begin(reqSum);
        HttpHost host = ApacheAsyncClient.determineTarget((HttpUriRequest)requestObj, request.getHeaders());
        this.apache.client.execute((HttpAsyncRequestProducer)new BasicAsyncRequestProducer(host, (org.apache.http.HttpRequest)requestObj), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (FutureCallback)new FutureCallback<org.apache.http.HttpResponse>(){

            public void completed(org.apache.http.HttpResponse httpResponse) {
                ApacheResponse t = new ApacheResponse(httpResponse, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
                metric.complete(t.toSummary(), null);
                HttpResponse response = ApacheAsyncClient.this.transformBody(transformer, t);
                ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config.getUniInterceptor().onResponse(response, reqSum, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
                callback.complete(response);
            }

            public void failed(Exception e) {
                metric.complete(null, e);
                try {
                    HttpResponse<?> r = ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config.getUniInterceptor().onFail(e, reqSum, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
                    callback.complete(r);
                }
                catch (Exception ee) {
                    callback.completeExceptionally(e);
                }
            }

            public void cancelled() {
                UnirestException canceled = new UnirestException("canceled");
                metric.complete(null, canceled);
                callback.completeExceptionally(canceled);
                ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config.getUniInterceptor().onFail(canceled, reqSum, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
            }
        });
        return callback;
    }

    @Override
    public boolean isRunning() {
        return this.apache.isRunning();
    }

    public HttpAsyncClient getClient() {
        return this.apache.getClient();
    }

    @Override
    public Stream<Exception> close() {
        return this.apache.close();
    }

    public static Builder builder(HttpAsyncClient client) {
        return new Builder(client);
    }

    public static class Builder
    implements Function<Config, AsyncClient> {
        private HttpAsyncClient asyncClient;
        private RequestConfigFactory cf;

        public Builder(HttpAsyncClient client) {
            this.asyncClient = client;
        }

        @Override
        public AsyncClient apply(Config config) {
            ApacheAsyncClient client = new ApacheAsyncClient(this.asyncClient, config);
            if (this.cf != null) {
                client.setConfigFactory(this.cf);
            }
            return client;
        }

        public Builder withRequestConfig(RequestConfigFactory factory) {
            Objects.requireNonNull(factory);
            this.cf = factory;
            return this;
        }
    }
}

