/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Cookie {
    private String name;
    private String value;
    private String domain;
    private String path;
    private boolean httpOnly;
    private Integer maxAge;
    private ZonedDateTime expires;
    private boolean secure;
    public static final DateTimeFormatter DEFAULT_PATTERN = DateTimeFormatter.ofPattern("EEE, dd-MMM-yyyy HH:mm:ss zzz");
    private static final List<DateTimeFormatter> FORMATS = Arrays.asList(DEFAULT_PATTERN, DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz"));

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String v) {
        this(v.split(";"));
    }

    private Cookie(String[] split) {
        int pos = 0;
        for (String s : split) {
            String[] sub;
            if (pos == 0) {
                sub = s.split("=");
                this.name = sub[0];
                this.value = this.getDecode(sub[1]);
            } else {
                sub = s.split("=");
                this.parseSection(sub);
            }
            ++pos;
        }
    }

    private String getDecode(String sub) {
        try {
            return URLDecoder.decode(sub, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return sub;
        }
    }

    private void parseSection(String[] sub) {
        switch (sub[0].toLowerCase()) {
            case "path": {
                this.path = sub[1];
                break;
            }
            case "domain": {
                this.domain = sub[1];
                break;
            }
            case "expires": {
                this.parseExpires(sub[1]);
                break;
            }
            case "max-age": {
                this.maxAge = Integer.parseInt(sub[1]);
                break;
            }
            case "httponly": {
                this.httpOnly = true;
                break;
            }
            case "secure": {
                this.secure = true;
            }
        }
    }

    private void parseExpires(String text) {
        FORMATS.forEach(f -> {
            try {
                this.expires = ZonedDateTime.parse(text, f);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        });
    }

    public String toString() {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        pairs.add(new Pair(this.name, this.value));
        if (this.path != null) {
            pairs.add(new Pair("Path", this.path));
        }
        if (this.domain != null) {
            pairs.add(new Pair("Domain", this.domain));
        }
        if (this.expires != null) {
            pairs.add(new Pair("Expires", this.expires.format(DEFAULT_PATTERN)));
        }
        if (this.maxAge != null) {
            pairs.add(new Pair("Max-Age", String.valueOf(this.maxAge)));
        }
        if (this.httpOnly) {
            pairs.add(new Pair("HttpOnly", null));
        }
        if (this.secure) {
            pairs.add(new Pair("Secure", null));
        }
        return pairs.stream().map(Pair::toString).collect(Collectors.joining(";"));
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public ZonedDateTime getExpiration() {
        return this.expires;
    }

    private static class Pair {
        final String key;
        final String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            if (this.value == null) {
                return this.key;
            }
            return this.key + "=" + this.value;
        }
    }
}

