/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.RemoteArgumentsArrayBuilder;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import com.lazerycode.jmeter.utility.StreamRedirector;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestManager.class);
    private JMeterArgumentsArray baseTestArgs;
    private File binDir;
    private File testFilesDirectory;
    private String[] testFilesIncluded = new String[]{"**/*.jmx"};
    private String[] testFilesExcluded = new String[0];
    private boolean suppressJMeterOutput;
    private boolean ignoreJVMKilledExitCode;
    private RemoteConfiguration remoteServerConfiguration;
    private JMeterProcessJVMSettings jMeterProcessJVMSettings;
    private long postTestPauseInSeconds = 0L;
    private String runtimeJarName;
    private File reportDirectory;
    private boolean generateReports = false;
    private static final int EXIT_CODE_FOR_JVM_KILLED = 143;

    public TestManager setBinDir(File file) {
        this.binDir = file;
        return this;
    }

    public TestManager setBaseTestArgs(JMeterArgumentsArray argumentsArray) {
        this.baseTestArgs = argumentsArray;
        return this;
    }

    public TestManager setTestFilesDirectory(File file) {
        this.testFilesDirectory = file;
        return this;
    }

    public TestManager setRemoteServerConfiguration(RemoteConfiguration configuration) {
        this.remoteServerConfiguration = configuration;
        return this;
    }

    public TestManager setSuppressJMeterOutput(Boolean value) {
        this.suppressJMeterOutput = value;
        return this;
    }

    public TestManager setJMeterProcessJVMSettings(JMeterProcessJVMSettings settings) {
        this.jMeterProcessJVMSettings = settings;
        return this;
    }

    public TestManager setRuntimeJarName(String value) {
        this.runtimeJarName = value;
        return this;
    }

    public TestManager setReportDirectory(File file) {
        this.reportDirectory = file;
        return this;
    }

    public TestManager setGenerateReports(Boolean value) {
        this.generateReports = value;
        return this;
    }

    public TestManager setTestFilesExcluded(List<String> values) {
        this.testFilesExcluded = values.toArray(new String[0]);
        return this;
    }

    public TestManager setTestFilesIncluded(List<String> values) {
        if (!values.isEmpty()) {
            this.testFilesIncluded = values.toArray(new String[0]);
        }
        return this;
    }

    public TestManager setIgnoreJVMKilled(Boolean ignoreJVMKillExitCode) {
        this.ignoreJVMKilledExitCode = ignoreJVMKillExitCode;
        return this;
    }

    public TestManager setPostTestPauseInSeconds(String postTestPauseInSeconds) {
        try {
            this.postTestPauseInSeconds = Long.parseLong(postTestPauseInSeconds);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Error parsing <postTestPauseInSeconds>{}</postTestPauseInSeconds> to Long, will default to 0L", (Object)postTestPauseInSeconds);
        }
        return this;
    }

    JMeterArgumentsArray getBaseTestArgs() {
        return this.baseTestArgs;
    }

    File getBinDir() {
        return this.binDir;
    }

    File getTestFilesDirectory() {
        return this.testFilesDirectory;
    }

    String[] getTestFilesIncluded() {
        return this.testFilesIncluded;
    }

    String[] getTestFilesExcluded() {
        return this.testFilesExcluded;
    }

    boolean isSuppressJMeterOutput() {
        return this.suppressJMeterOutput;
    }

    RemoteConfiguration getRemoteServerConfiguration() {
        return this.remoteServerConfiguration;
    }

    JMeterProcessJVMSettings getJMeterProcessJVMSettings() {
        return this.jMeterProcessJVMSettings;
    }

    long getPostTestPauseInSeconds() {
        return this.postTestPauseInSeconds;
    }

    String getRuntimeJarName() {
        return this.runtimeJarName;
    }

    File getReportDirectory() {
        return this.reportDirectory;
    }

    boolean isGenerateReports() {
        return this.generateReports;
    }

    public List<String> executeTests() throws MojoExecutionException {
        JMeterArgumentsArray thisTestArgs = this.baseTestArgs;
        List<String> tests = this.generateTestList();
        ArrayList<String> results = new ArrayList<String>();
        for (String file : tests) {
            if (this.generateReports) {
                File outputReportFolder = new File(this.reportDirectory + File.separator + FilenameUtils.removeExtension((String)file));
                LOGGER.info("Will generate HTML report in {}", (Object)outputReportFolder.getAbsolutePath());
                if (outputReportFolder.exists() || outputReportFolder.mkdirs()) {
                    thisTestArgs.setReportsDirectory(outputReportFolder.getAbsolutePath());
                } else {
                    throw new MojoExecutionException("Unable to create report output folder:" + outputReportFolder.getAbsolutePath());
                }
            }
            if (this.remoteServerConfiguration.isStartServersBeforeTests() && tests.get(0).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                thisTestArgs.setRemoteStart();
                thisTestArgs.setRemoteStartServerList(this.remoteServerConfiguration.getServerList());
            }
            if (this.remoteServerConfiguration.isStopServersAfterTests() && tests.get(tests.size() - 1).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                thisTestArgs.setRemoteStop();
            }
            results.add(this.executeSingleTest(new File(this.testFilesDirectory, file), thisTestArgs));
            try {
                TimeUnit.SECONDS.sleep(this.postTestPauseInSeconds);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        return results;
    }

    private String executeSingleTest(File test, JMeterArgumentsArray testArgs) throws MojoExecutionException {
        testArgs.setTestFile(test, this.testFilesDirectory);
        File currentResultsFile = new File(testArgs.getResultsLogFileName());
        if (currentResultsFile.exists()) {
            LOGGER.info("{} already exists!, deleting file in preparation for new test run...", (Object)currentResultsFile);
            if (!currentResultsFile.delete()) {
                throw new MojoExecutionException("Failed to delete existing results file:" + currentResultsFile.getAbsolutePath());
            }
        }
        List<String> argumentsArray = testArgs.buildArgumentsArray();
        argumentsArray.addAll(RemoteArgumentsArrayBuilder.buildRemoteArgumentsArray(this.remoteServerConfiguration.getPropertiesMap()));
        LOGGER.info("Executing test: {}", (Object)test.getName());
        JMeterProcessBuilder jmeterProcessBuilder = new JMeterProcessBuilder(this.jMeterProcessJVMSettings, this.runtimeJarName);
        jmeterProcessBuilder.setWorkingDirectory(this.binDir);
        jmeterProcessBuilder.addArguments(argumentsArray);
        try {
            Process process = jmeterProcessBuilder.build().start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOGGER.info("Shutdown detected, destroying JMeter process...");
                LOGGER.info(" ");
                process.destroy();
            }));
            new Thread(new StreamRedirector(process.getInputStream(), this.suppressJMeterOutput ? arg_0 -> ((Logger)LOGGER).debug(arg_0) : arg_0 -> ((Logger)LOGGER).info(arg_0))).start();
            new Thread(new StreamRedirector(process.getErrorStream(), arg_0 -> ((Logger)LOGGER).error(arg_0))).start();
            int jMeterExitCode = process.waitFor();
            if (jMeterExitCode != 0) {
                if (this.ignoreJVMKilledExitCode && jMeterExitCode == 143) {
                    LOGGER.warn("JVM has been force killed!");
                    LOGGER.warn("Build failure not triggered due to config settings, however you may want to investigate this");
                } else {
                    throw new MojoExecutionException("Test failed with exit code:" + jMeterExitCode);
                }
            }
            LOGGER.info("Completed Test: {}", (Object)test.getAbsolutePath());
            LOGGER.info(" ");
        }
        catch (InterruptedException ex) {
            LOGGER.info(" ");
            LOGGER.info("System Exit Detected!  Stopping Test...");
            LOGGER.info(" ");
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        return testArgs.getResultsLogFileName();
    }

    List<String> generateTestList() {
        if (UtilityFunctions.isNotSet(this.testFilesDirectory).booleanValue()) {
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testFilesDirectory);
        scanner.setIncludes(this.testFilesIncluded);
        scanner.setExcludes(this.testFilesExcluded);
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }
}

