/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.expando.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ExpandoColumn service. Represents a row in the &quot;ExpandoColumn&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portlet.expando.model.impl.ExpandoColumnModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portlet.expando.model.impl.ExpandoColumnImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ExpandoColumn
 * @generated
 */
@ProviderType
public interface ExpandoColumnModel
	extends BaseModel<ExpandoColumn>, CTModel<ExpandoColumn>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a expando column model instance should use the {@link ExpandoColumn} interface instead.
	 */

	/**
	 * Returns the primary key of this expando column.
	 *
	 * @return the primary key of this expando column
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this expando column.
	 *
	 * @param primaryKey the primary key of this expando column
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this expando column.
	 *
	 * @return the mvcc version of this expando column
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this expando column.
	 *
	 * @param mvccVersion the mvcc version of this expando column
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this expando column.
	 *
	 * @return the ct collection ID of this expando column
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this expando column.
	 *
	 * @param ctCollectionId the ct collection ID of this expando column
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the column ID of this expando column.
	 *
	 * @return the column ID of this expando column
	 */
	public long getColumnId();

	/**
	 * Sets the column ID of this expando column.
	 *
	 * @param columnId the column ID of this expando column
	 */
	public void setColumnId(long columnId);

	/**
	 * Returns the company ID of this expando column.
	 *
	 * @return the company ID of this expando column
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this expando column.
	 *
	 * @param companyId the company ID of this expando column
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the modified date of this expando column.
	 *
	 * @return the modified date of this expando column
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this expando column.
	 *
	 * @param modifiedDate the modified date of this expando column
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the table ID of this expando column.
	 *
	 * @return the table ID of this expando column
	 */
	public long getTableId();

	/**
	 * Sets the table ID of this expando column.
	 *
	 * @param tableId the table ID of this expando column
	 */
	public void setTableId(long tableId);

	/**
	 * Returns the name of this expando column.
	 *
	 * @return the name of this expando column
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this expando column.
	 *
	 * @param name the name of this expando column
	 */
	public void setName(String name);

	/**
	 * Returns the type of this expando column.
	 *
	 * @return the type of this expando column
	 */
	public int getType();

	/**
	 * Sets the type of this expando column.
	 *
	 * @param type the type of this expando column
	 */
	public void setType(int type);

	/**
	 * Returns the default data of this expando column.
	 *
	 * @return the default data of this expando column
	 */
	@AutoEscape
	public String getDefaultData();

	/**
	 * Sets the default data of this expando column.
	 *
	 * @param defaultData the default data of this expando column
	 */
	public void setDefaultData(String defaultData);

	/**
	 * Returns the type settings of this expando column.
	 *
	 * @return the type settings of this expando column
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this expando column.
	 *
	 * @param typeSettings the type settings of this expando column
	 */
	public void setTypeSettings(String typeSettings);

	@Override
	public ExpandoColumn cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}