/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the RememberMeToken service. Represents a row in the &quot;RememberMeToken&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.RememberMeTokenModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.RememberMeTokenImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RememberMeToken
 * @generated
 */
@ProviderType
public interface RememberMeTokenModel
	extends BaseModel<RememberMeToken>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a remember me token model instance should use the {@link RememberMeToken} interface instead.
	 */

	/**
	 * Returns the primary key of this remember me token.
	 *
	 * @return the primary key of this remember me token
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this remember me token.
	 *
	 * @param primaryKey the primary key of this remember me token
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this remember me token.
	 *
	 * @return the mvcc version of this remember me token
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this remember me token.
	 *
	 * @param mvccVersion the mvcc version of this remember me token
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the remember me token ID of this remember me token.
	 *
	 * @return the remember me token ID of this remember me token
	 */
	public long getRememberMeTokenId();

	/**
	 * Sets the remember me token ID of this remember me token.
	 *
	 * @param rememberMeTokenId the remember me token ID of this remember me token
	 */
	public void setRememberMeTokenId(long rememberMeTokenId);

	/**
	 * Returns the company ID of this remember me token.
	 *
	 * @return the company ID of this remember me token
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this remember me token.
	 *
	 * @param companyId the company ID of this remember me token
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this remember me token.
	 *
	 * @return the user ID of this remember me token
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this remember me token.
	 *
	 * @param userId the user ID of this remember me token
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this remember me token.
	 *
	 * @return the user uuid of this remember me token
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this remember me token.
	 *
	 * @param userUuid the user uuid of this remember me token
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this remember me token.
	 *
	 * @return the create date of this remember me token
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this remember me token.
	 *
	 * @param createDate the create date of this remember me token
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the expiration date of this remember me token.
	 *
	 * @return the expiration date of this remember me token
	 */
	public Date getExpirationDate();

	/**
	 * Sets the expiration date of this remember me token.
	 *
	 * @param expirationDate the expiration date of this remember me token
	 */
	public void setExpirationDate(Date expirationDate);

	/**
	 * Returns the value of this remember me token.
	 *
	 * @return the value of this remember me token
	 */
	@AutoEscape
	public String getValue();

	/**
	 * Sets the value of this remember me token.
	 *
	 * @param value the value of this remember me token
	 */
	public void setValue(String value);

	@Override
	public RememberMeToken cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}