/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the UserNotificationDelivery service. Represents a row in the &quot;UserNotificationDelivery&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.UserNotificationDeliveryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.UserNotificationDeliveryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserNotificationDelivery
 * @generated
 */
@ProviderType
public interface UserNotificationDeliveryModel
	extends BaseModel<UserNotificationDelivery>, MVCCModel, ShardedModel,
			TypedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a user notification delivery model instance should use the {@link UserNotificationDelivery} interface instead.
	 */

	/**
	 * Returns the primary key of this user notification delivery.
	 *
	 * @return the primary key of this user notification delivery
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this user notification delivery.
	 *
	 * @param primaryKey the primary key of this user notification delivery
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this user notification delivery.
	 *
	 * @return the mvcc version of this user notification delivery
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this user notification delivery.
	 *
	 * @param mvccVersion the mvcc version of this user notification delivery
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the user notification delivery ID of this user notification delivery.
	 *
	 * @return the user notification delivery ID of this user notification delivery
	 */
	public long getUserNotificationDeliveryId();

	/**
	 * Sets the user notification delivery ID of this user notification delivery.
	 *
	 * @param userNotificationDeliveryId the user notification delivery ID of this user notification delivery
	 */
	public void setUserNotificationDeliveryId(long userNotificationDeliveryId);

	/**
	 * Returns the company ID of this user notification delivery.
	 *
	 * @return the company ID of this user notification delivery
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this user notification delivery.
	 *
	 * @param companyId the company ID of this user notification delivery
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this user notification delivery.
	 *
	 * @return the user ID of this user notification delivery
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this user notification delivery.
	 *
	 * @param userId the user ID of this user notification delivery
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this user notification delivery.
	 *
	 * @return the user uuid of this user notification delivery
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this user notification delivery.
	 *
	 * @param userUuid the user uuid of this user notification delivery
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the portlet ID of this user notification delivery.
	 *
	 * @return the portlet ID of this user notification delivery
	 */
	@AutoEscape
	public String getPortletId();

	/**
	 * Sets the portlet ID of this user notification delivery.
	 *
	 * @param portletId the portlet ID of this user notification delivery
	 */
	public void setPortletId(String portletId);

	/**
	 * Returns the fully qualified class name of this user notification delivery.
	 *
	 * @return the fully qualified class name of this user notification delivery
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this user notification delivery.
	 *
	 * @return the class name ID of this user notification delivery
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this user notification delivery.
	 *
	 * @param classNameId the class name ID of this user notification delivery
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the notification type of this user notification delivery.
	 *
	 * @return the notification type of this user notification delivery
	 */
	public int getNotificationType();

	/**
	 * Sets the notification type of this user notification delivery.
	 *
	 * @param notificationType the notification type of this user notification delivery
	 */
	public void setNotificationType(int notificationType);

	/**
	 * Returns the delivery type of this user notification delivery.
	 *
	 * @return the delivery type of this user notification delivery
	 */
	public int getDeliveryType();

	/**
	 * Sets the delivery type of this user notification delivery.
	 *
	 * @param deliveryType the delivery type of this user notification delivery
	 */
	public void setDeliveryType(int deliveryType);

	/**
	 * Returns the deliver of this user notification delivery.
	 *
	 * @return the deliver of this user notification delivery
	 */
	public boolean getDeliver();

	/**
	 * Returns <code>true</code> if this user notification delivery is deliver.
	 *
	 * @return <code>true</code> if this user notification delivery is deliver; <code>false</code> otherwise
	 */
	public boolean isDeliver();

	/**
	 * Sets whether this user notification delivery is deliver.
	 *
	 * @param deliver the deliver of this user notification delivery
	 */
	public void setDeliver(boolean deliver);

	@Override
	public UserNotificationDelivery cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}