/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.service.persistence;

import com.liferay.portal.kernel.exception.NoSuchRememberMeTokenException;
import com.liferay.portal.kernel.model.RememberMeToken;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The persistence interface for the remember me token service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RememberMeTokenUtil
 * @generated
 */
@ProviderType
public interface RememberMeTokenPersistence
	extends BasePersistence<RememberMeToken> {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link RememberMeTokenUtil} to access the remember me token persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	 * Returns all the remember me tokens where userId = &#63;.
	 *
	 * @param userId the user ID
	 * @return the matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByUserId(long userId);

	/**
	 * Returns a range of all the remember me tokens where userId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param userId the user ID
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @return the range of matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByUserId(
		long userId, int start, int end);

	/**
	 * Returns an ordered range of all the remember me tokens where userId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param userId the user ID
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByUserId(
		long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns an ordered range of all the remember me tokens where userId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param userId the user ID
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByUserId(
		long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator,
		boolean useFinderCache);

	/**
	 * Returns the first remember me token in the ordered set where userId = &#63;.
	 *
	 * @param userId the user ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching remember me token
	 * @throws NoSuchRememberMeTokenException if a matching remember me token could not be found
	 */
	public RememberMeToken findByUserId_First(
			long userId,
			com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
				orderByComparator)
		throws NoSuchRememberMeTokenException;

	/**
	 * Returns the first remember me token in the ordered set where userId = &#63;.
	 *
	 * @param userId the user ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching remember me token, or <code>null</code> if a matching remember me token could not be found
	 */
	public RememberMeToken fetchByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns the last remember me token in the ordered set where userId = &#63;.
	 *
	 * @param userId the user ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching remember me token
	 * @throws NoSuchRememberMeTokenException if a matching remember me token could not be found
	 */
	public RememberMeToken findByUserId_Last(
			long userId,
			com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
				orderByComparator)
		throws NoSuchRememberMeTokenException;

	/**
	 * Returns the last remember me token in the ordered set where userId = &#63;.
	 *
	 * @param userId the user ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching remember me token, or <code>null</code> if a matching remember me token could not be found
	 */
	public RememberMeToken fetchByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns the remember me tokens before and after the current remember me token in the ordered set where userId = &#63;.
	 *
	 * @param rememberMeTokenId the primary key of the current remember me token
	 * @param userId the user ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next remember me token
	 * @throws NoSuchRememberMeTokenException if a remember me token with the primary key could not be found
	 */
	public RememberMeToken[] findByUserId_PrevAndNext(
			long rememberMeTokenId, long userId,
			com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
				orderByComparator)
		throws NoSuchRememberMeTokenException;

	/**
	 * Removes all the remember me tokens where userId = &#63; from the database.
	 *
	 * @param userId the user ID
	 */
	public void removeByUserId(long userId);

	/**
	 * Returns the number of remember me tokens where userId = &#63;.
	 *
	 * @param userId the user ID
	 * @return the number of matching remember me tokens
	 */
	public int countByUserId(long userId);

	/**
	 * Returns all the remember me tokens where expirationDate &le; &#63;.
	 *
	 * @param expirationDate the expiration date
	 * @return the matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByLteExpirationDate(
		Date expirationDate);

	/**
	 * Returns a range of all the remember me tokens where expirationDate &le; &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param expirationDate the expiration date
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @return the range of matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByLteExpirationDate(
		Date expirationDate, int start, int end);

	/**
	 * Returns an ordered range of all the remember me tokens where expirationDate &le; &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param expirationDate the expiration date
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByLteExpirationDate(
		Date expirationDate, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns an ordered range of all the remember me tokens where expirationDate &le; &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param expirationDate the expiration date
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of matching remember me tokens
	 */
	public java.util.List<RememberMeToken> findByLteExpirationDate(
		Date expirationDate, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator,
		boolean useFinderCache);

	/**
	 * Returns the first remember me token in the ordered set where expirationDate &le; &#63;.
	 *
	 * @param expirationDate the expiration date
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching remember me token
	 * @throws NoSuchRememberMeTokenException if a matching remember me token could not be found
	 */
	public RememberMeToken findByLteExpirationDate_First(
			Date expirationDate,
			com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
				orderByComparator)
		throws NoSuchRememberMeTokenException;

	/**
	 * Returns the first remember me token in the ordered set where expirationDate &le; &#63;.
	 *
	 * @param expirationDate the expiration date
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching remember me token, or <code>null</code> if a matching remember me token could not be found
	 */
	public RememberMeToken fetchByLteExpirationDate_First(
		Date expirationDate,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns the last remember me token in the ordered set where expirationDate &le; &#63;.
	 *
	 * @param expirationDate the expiration date
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching remember me token
	 * @throws NoSuchRememberMeTokenException if a matching remember me token could not be found
	 */
	public RememberMeToken findByLteExpirationDate_Last(
			Date expirationDate,
			com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
				orderByComparator)
		throws NoSuchRememberMeTokenException;

	/**
	 * Returns the last remember me token in the ordered set where expirationDate &le; &#63;.
	 *
	 * @param expirationDate the expiration date
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching remember me token, or <code>null</code> if a matching remember me token could not be found
	 */
	public RememberMeToken fetchByLteExpirationDate_Last(
		Date expirationDate,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns the remember me tokens before and after the current remember me token in the ordered set where expirationDate &le; &#63;.
	 *
	 * @param rememberMeTokenId the primary key of the current remember me token
	 * @param expirationDate the expiration date
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next remember me token
	 * @throws NoSuchRememberMeTokenException if a remember me token with the primary key could not be found
	 */
	public RememberMeToken[] findByLteExpirationDate_PrevAndNext(
			long rememberMeTokenId, Date expirationDate,
			com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
				orderByComparator)
		throws NoSuchRememberMeTokenException;

	/**
	 * Removes all the remember me tokens where expirationDate &le; &#63; from the database.
	 *
	 * @param expirationDate the expiration date
	 */
	public void removeByLteExpirationDate(Date expirationDate);

	/**
	 * Returns the number of remember me tokens where expirationDate &le; &#63;.
	 *
	 * @param expirationDate the expiration date
	 * @return the number of matching remember me tokens
	 */
	public int countByLteExpirationDate(Date expirationDate);

	/**
	 * Caches the remember me token in the entity cache if it is enabled.
	 *
	 * @param rememberMeToken the remember me token
	 */
	public void cacheResult(RememberMeToken rememberMeToken);

	/**
	 * Caches the remember me tokens in the entity cache if it is enabled.
	 *
	 * @param rememberMeTokens the remember me tokens
	 */
	public void cacheResult(java.util.List<RememberMeToken> rememberMeTokens);

	/**
	 * Creates a new remember me token with the primary key. Does not add the remember me token to the database.
	 *
	 * @param rememberMeTokenId the primary key for the new remember me token
	 * @return the new remember me token
	 */
	public RememberMeToken create(long rememberMeTokenId);

	/**
	 * Removes the remember me token with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param rememberMeTokenId the primary key of the remember me token
	 * @return the remember me token that was removed
	 * @throws NoSuchRememberMeTokenException if a remember me token with the primary key could not be found
	 */
	public RememberMeToken remove(long rememberMeTokenId)
		throws NoSuchRememberMeTokenException;

	public RememberMeToken updateImpl(RememberMeToken rememberMeToken);

	/**
	 * Returns the remember me token with the primary key or throws a <code>NoSuchRememberMeTokenException</code> if it could not be found.
	 *
	 * @param rememberMeTokenId the primary key of the remember me token
	 * @return the remember me token
	 * @throws NoSuchRememberMeTokenException if a remember me token with the primary key could not be found
	 */
	public RememberMeToken findByPrimaryKey(long rememberMeTokenId)
		throws NoSuchRememberMeTokenException;

	/**
	 * Returns the remember me token with the primary key or returns <code>null</code> if it could not be found.
	 *
	 * @param rememberMeTokenId the primary key of the remember me token
	 * @return the remember me token, or <code>null</code> if a remember me token with the primary key could not be found
	 */
	public RememberMeToken fetchByPrimaryKey(long rememberMeTokenId);

	/**
	 * Returns all the remember me tokens.
	 *
	 * @return the remember me tokens
	 */
	public java.util.List<RememberMeToken> findAll();

	/**
	 * Returns a range of all the remember me tokens.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @return the range of remember me tokens
	 */
	public java.util.List<RememberMeToken> findAll(int start, int end);

	/**
	 * Returns an ordered range of all the remember me tokens.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of remember me tokens
	 */
	public java.util.List<RememberMeToken> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator);

	/**
	 * Returns an ordered range of all the remember me tokens.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>RememberMeTokenModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of remember me tokens
	 * @param end the upper bound of the range of remember me tokens (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of remember me tokens
	 */
	public java.util.List<RememberMeToken> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator<RememberMeToken>
			orderByComparator,
		boolean useFinderCache);

	/**
	 * Removes all the remember me tokens from the database.
	 */
	public void removeAll();

	/**
	 * Returns the number of remember me tokens.
	 *
	 * @return the number of remember me tokens
	 */
	public int countAll();

}