/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel;

import com.liferay.asset.kernel.AssetRendererFactoryCustomizer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;

public class AssetRendererFactoryRegistryUtil {
    private static final Snapshot<AssetRendererFactoryCustomizer> _assetRendererFactoryCustomizerSnapshot = new Snapshot<AssetRendererFactoryCustomizer>(AssetRendererFactoryRegistryUtil.class, AssetRendererFactoryCustomizer.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, AssetRendererFactory<?>> _classNameAssetRenderFactoriesServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, AssetRendererFactory.class, null, (serviceReference, emitter) -> {
        AssetRendererFactory assetRendererFactory = (AssetRendererFactory)_bundleContext.getService(serviceReference);
        emitter.emit((Object)assetRendererFactory.getClassName());
    });
    private static final ServiceTrackerMap<String, AssetRendererFactory<?>> _typeAssetRenderFactoriesServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, AssetRendererFactory.class, null, (serviceReference, emitter) -> {
        AssetRendererFactory assetRendererFactory = (AssetRendererFactory)_bundleContext.getService(serviceReference);
        emitter.emit((Object)assetRendererFactory.getType());
    });

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId) {
        return AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, false);
    }

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId, boolean filterSelectable) {
        return AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, filterSelectable);
    }

    public static <T> AssetRendererFactory<T> getAssetRendererFactoryByClass(Class<T> clazz) {
        return AssetRendererFactoryRegistryUtil._customize((AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)clazz.getName()));
    }

    public static <T> AssetRendererFactory<T> getAssetRendererFactoryByClassName(String className) {
        return AssetRendererFactoryRegistryUtil._customize((AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)className));
    }

    public static <T> AssetRendererFactory<T> getAssetRendererFactoryByClassNameId(long classNameId) {
        return AssetRendererFactoryRegistryUtil._customize((AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)PortalUtil.getClassName(classNameId)));
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByType(String type) {
        return (AssetRendererFactory)_typeAssetRenderFactoriesServiceTrackerMap.getService((Object)type);
    }

    public static long[] getClassNameIds(long companyId) {
        return AssetRendererFactoryRegistryUtil.getClassNameIds(companyId, false);
    }

    public static long[] getClassNameIds(long companyId, boolean filterSelectable) {
        if (companyId > 0L) {
            return TransformUtil.transformToLongArray(AssetRendererFactoryRegistryUtil._filterAssetRendererFactories(companyId, filterSelectable), AssetRendererFactory::getClassNameId);
        }
        return TransformUtil.transformToLongArray((Collection)_classNameAssetRenderFactoriesServiceTrackerMap.keySet(), className -> {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil._customize((AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService(className));
            return assetRendererFactory.getClassNameId();
        });
    }

    public static long[] getIndexableClassNameIds(long companyId, boolean filterSelectable) {
        return ArrayUtil.filter(AssetRendererFactoryRegistryUtil.getClassNameIds(companyId, filterSelectable), classNameId -> {
            Indexer indexer = IndexerRegistryUtil.getIndexer(PortalUtil.getClassName(classNameId));
            return indexer != null;
        });
    }

    private static <T> AssetRendererFactory<T> _customize(AssetRendererFactory<T> assetRendererFactory) {
        if (assetRendererFactory == null) {
            return null;
        }
        AssetRendererFactoryCustomizer assetRendererFactoryCustomizer = _assetRendererFactoryCustomizerSnapshot.get();
        if (assetRendererFactoryCustomizer != null) {
            assetRendererFactory = assetRendererFactoryCustomizer.customize(assetRendererFactory);
        }
        return assetRendererFactory;
    }

    private static List<AssetRendererFactory<?>> _filterAssetRendererFactories(long companyId, boolean filterSelectable) {
        CopyOnWriteArrayList filteredAssetRendererFactories = new CopyOnWriteArrayList();
        for (String key : _classNameAssetRenderFactoriesServiceTrackerMap.keySet()) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil._customize((AssetRendererFactory)_classNameAssetRenderFactoriesServiceTrackerMap.getService((Object)key));
            if (!assetRendererFactory.isActive(companyId) || filterSelectable && !assetRendererFactory.isSelectable()) continue;
            filteredAssetRendererFactories.add(assetRendererFactory);
        }
        return filteredAssetRendererFactories;
    }

    private AssetRendererFactoryRegistryUtil() {
    }
}

