/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.BaseAssetRenderer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPAssetRenderer<T>
extends BaseAssetRenderer<T>
implements AssetRenderer<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPAssetRenderer.class);
    private ServletContext _servletContext;

    public abstract String getJspPath(HttpServletRequest var1, String var2);

    @Override
    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        String jspPath = this.getJspPath(httpServletRequest, template);
        if (Validator.isNull(jspPath)) {
            return false;
        }
        ResourceBundleLoader originalResourceBundleLoader = (ResourceBundleLoader)httpServletRequest.getAttribute("RESOURCE_BUNDLE_LOADER");
        ServletContext servletContext = this.getServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(jspPath);
        try {
            httpServletRequest.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)this.acquireResourceBundleLoader());
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            boolean bl = true;
            return bl;
        }
        catch (ServletException servletException) {
            _log.error("Unable to include JSP " + jspPath, servletException);
            throw new IOException("Unable to include " + jspPath, servletException);
        }
        finally {
            httpServletRequest.setAttribute("RESOURCE_BUNDLE_LOADER", (Object)originalResourceBundleLoader);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected ResourceBundleLoader acquireResourceBundleLoader() {
        if (this._servletContext != null) {
            ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName(this._servletContext.getServletContextName());
            if (resourceBundleLoader == null) {
                return ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
            return resourceBundleLoader;
        }
        return new AggregateResourceBundleLoader(new ClassResourceBundleLoader("content.Language", this.getClass()), ResourceBundleLoaderUtil.getPortalResourceBundleLoader());
    }

    protected ServletContext getServletContext() {
        if (this._servletContext != null) {
            return this._servletContext;
        }
        PortletBag portletBag = PortletBagPool.get(this.getAssetRendererFactory().getPortletId());
        return portletBag.getServletContext();
    }
}

