/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.store;

import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;

public enum StoreArea {
    DELETED("_deleted"),
    LIVE(""),
    NEW("_new");

    private static final ThreadLocal<StoreArea> _storeAreaThreadLocal;
    private final String _namespace;

    public static String getCurrentStoreAreaPath(long companyId, long repositoryId, String ... path) {
        StoreArea storeArea = _storeAreaThreadLocal.get();
        return storeArea.getPath(companyId, repositoryId, path);
    }

    public static <E extends Exception> String[] mergeWithStoreAreas(UnsafeSupplier<String[], E> unsafeSupplier, StoreArea ... storeAreas) throws E {
        ArrayList list = new ArrayList();
        Exception exception1 = null;
        int exceptionsCount = 0;
        for (StoreArea storeArea : storeAreas) {
            try {
                String[] strings = StoreArea.withStoreArea(storeArea, unsafeSupplier);
                if (strings == null) continue;
                Collections.addAll(list, strings);
            }
            catch (Exception exception2) {
                ++exceptionsCount;
                if (exception1 != null) continue;
                exception1 = exception2;
            }
        }
        if (exceptionsCount == storeAreas.length) {
            return (String[])ReflectionUtil.throwException(exception1);
        }
        return list.toArray(new String[0]);
    }

    public static <T extends Exception> void runWithStoreAreas(UnsafeRunnable<T> unsafeRunnable, StoreArea ... storeAreas) throws T {
        Exception exception1 = null;
        int exceptionsCount = 0;
        for (StoreArea storeArea : storeAreas) {
            try {
                StoreArea.withStoreArea(storeArea, unsafeRunnable);
            }
            catch (Exception exception2) {
                ++exceptionsCount;
                if (exception1 != null) continue;
                exception1 = exception2;
            }
        }
        if (exceptionsCount == storeAreas.length) {
            ReflectionUtil.throwException(exception1);
        }
    }

    public static <T, E extends Exception> T tryGetWithStoreAreas(UnsafeSupplier<T, E> unsafeSupplier, Predicate<T> predicate, T defaultValue, StoreArea ... storeAreas) throws E {
        Exception exception1 = null;
        for (StoreArea storeArea : storeAreas) {
            try {
                T result = StoreArea.withStoreArea(storeArea, unsafeSupplier);
                if (!predicate.test(result)) continue;
                return result;
            }
            catch (Exception exception2) {
                if (exception1 != null) continue;
                exception1 = exception2;
            }
        }
        if (exception1 != null) {
            return (T)ReflectionUtil.throwException(exception1);
        }
        return defaultValue;
    }

    public static StoreArea tryRunWithStoreAreas(Predicate<StoreArea> predicate, StoreArea ... storeAreas) {
        Exception exception1 = null;
        for (StoreArea storeArea : storeAreas) {
            try {
                if (!predicate.test(storeArea)) continue;
                return storeArea;
            }
            catch (Exception exception2) {
                if (exception1 != null) continue;
                exception1 = exception2;
            }
        }
        if (exception1 != null) {
            return (StoreArea)((Object)ReflectionUtil.throwException(exception1));
        }
        return null;
    }

    public static <T extends Throwable> void withStoreArea(StoreArea storeArea, UnsafeRunnable<T> unsafeRunnable) throws T {
        StoreArea.withStoreArea(storeArea, () -> {
            unsafeRunnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withStoreArea(StoreArea storeArea, UnsafeSupplier<T, E> unsafeSupplier) throws E {
        StoreArea oldStoreArea = _storeAreaThreadLocal.get();
        try {
            _storeAreaThreadLocal.set(storeArea);
            Object object = unsafeSupplier.get();
            return (T)object;
        }
        finally {
            _storeAreaThreadLocal.set(oldStoreArea);
        }
    }

    public String getPath(long companyId) {
        return StringBundler.concat(this._namespace, "/", String.valueOf(companyId));
    }

    public String getPath(long companyId, long repositoryId, String ... path) {
        StringBundler sb = new StringBundler(5 + ArrayUtil.getLength(path) * 2);
        if (Validator.isNotNull(this._namespace)) {
            sb.append(this._namespace);
            sb.append("/");
        }
        sb.append(String.valueOf(companyId));
        sb.append("/");
        sb.append(String.valueOf(repositoryId));
        if (ArrayUtil.isNotEmpty(path)) {
            sb.append("/");
            sb.append(this._join(path, "/"));
        }
        return sb.toString();
    }

    public String relocate(String name, StoreArea storeArea) {
        if (!name.startsWith(this._namespace)) {
            return storeArea._namespace + "/" + name;
        }
        return storeArea._namespace + name.substring(this._namespace.length());
    }

    private StoreArea(String namespace) {
        this._namespace = namespace;
    }

    private <T> String _join(T[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            String value = StringUtil.trim(String.valueOf(array[i]));
            if (i != 0 && StringUtil.startsWith(value, delimiter)) {
                value = value.substring(1);
            }
            if (i != array.length - 1 && StringUtil.endsWith(value, delimiter)) {
                value = value.substring(0, value.length() - 1);
            }
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(value);
        }
        return sb.toString();
    }

    static {
        _storeAreaThreadLocal = new CentralizedThreadLocal(StoreArea.class.getName() + "._storeAreaThreadLocal", () -> LIVE);
    }
}

