/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.kernel.service.permission;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;

public class ExpandoColumnPermissionUtil {
    public static void check(PermissionChecker permissionChecker, ExpandoColumn column, String actionId) throws PortalException {
        if (!ExpandoColumnPermissionUtil.contains(permissionChecker, column, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ExpandoColumn.class.getName(), column.getColumnId(), actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long columnId, String actionId) throws PortalException {
        if (!ExpandoColumnPermissionUtil.contains(permissionChecker, columnId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ExpandoColumn.class.getName(), columnId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long companyId, String className, String tableName, String columnName, String actionId) throws PortalException {
        ExpandoColumnPermissionUtil.check(permissionChecker, ExpandoColumnLocalServiceUtil.getColumn(companyId, ClassNameLocalServiceUtil.getClassNameId(className), tableName, columnName), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, ExpandoColumn column, String actionId) {
        return permissionChecker.hasPermission(null, ExpandoColumn.class.getName(), column.getColumnId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long columnId, String actionId) throws PortalException {
        return ExpandoColumnPermissionUtil.contains(permissionChecker, ExpandoColumnLocalServiceUtil.getColumn(columnId), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, String className, String tableName, String columnName, String actionId) {
        return ExpandoColumnPermissionUtil.contains(permissionChecker, ExpandoColumnLocalServiceUtil.getColumn(companyId, className, tableName, columnName), actionId);
    }
}

