/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.spring.orm.LastSessionRecorderHelperUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StagedModelDataHandlerUtil {
    private static final Log _log = LogFactoryUtil.getLog(StagedModelDataHandlerUtil.class);

    public static void deleteStagedModel(PortletDataContext portletDataContext, Element deletionElement) throws PortalException {
        String className = deletionElement.attributeValue("class-name");
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(className);
        if (stagedModelDataHandler != null) {
            String extraData = deletionElement.attributeValue("extra-data");
            String uuid = deletionElement.attributeValue("uuid");
            stagedModelDataHandler.deleteStagedModel(uuid, portletDataContext.getScopeGroupId(), className, extraData);
        }
    }

    public static <T extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, String referrerPortletId, T stagedModel) throws PortletDataException {
        Portlet referrerPortlet = PortletLocalServiceUtil.getPortletById(referrerPortletId);
        if (!ExportImportHelperUtil.isPublishDisplayedContent(portletDataContext, referrerPortlet)) {
            return portletDataContext.addReferenceElement(referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, "weak", true);
        }
        if (!ExportImportHelperUtil.isAlwaysIncludeReference(portletDataContext, stagedModel) || !ExportImportHelperUtil.isReferenceWithinExportScope(portletDataContext, stagedModel)) {
            return portletDataContext.addReferenceElement(referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, "dependency", true);
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        return portletDataContext.addReferenceElement(referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, "dependency", false);
    }

    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, U stagedModel, String referenceType) throws PortletDataException {
        Element referrerStagedModelElement = portletDataContext.getExportDataElement(referrerStagedModel);
        if (!ExportImportHelperUtil.isAlwaysIncludeReference(portletDataContext, stagedModel) || !ExportImportHelperUtil.isReferenceWithinExportScope(portletDataContext, stagedModel)) {
            return portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, "dependency", true);
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        return portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, referenceType, false);
    }

    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, U stagedModel, String referenceType, String portletId) throws PortletDataException {
        Element referrerStagedModelElement = portletDataContext.getExportDataElement(referrerStagedModel);
        if (!ExportImportHelperUtil.isAlwaysIncludeReference(portletDataContext, stagedModel, portletId) || !ExportImportHelperUtil.isReferenceWithinExportScope(portletDataContext, stagedModel)) {
            return portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, "dependency", true);
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        return portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, referenceType, false);
    }

    public static <T extends StagedModel> void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        if (!ExportImportHelperUtil.isReferenceWithinExportScope(portletDataContext, stagedModel)) {
            return;
        }
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return;
        }
        stagedModelDataHandler.exportStagedModel(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> String getDisplayName(T stagedModel) {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return "";
        }
        return stagedModelDataHandler.getDisplayName(stagedModel);
    }

    public static Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, StagedModel stagedModel) {
        StagedModelDataHandler<StagedModel> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return Collections.emptyMap();
        }
        return stagedModelDataHandler.getReferenceAttributes(portletDataContext, stagedModel);
    }

    public static void importReferenceStagedModel(PortletDataContext portletDataContext, Class<?> stagedModelClass, Serializable classPK) throws PortletDataException {
        StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, stagedModelClass.getName(), classPK);
    }

    public static void importReferenceStagedModel(PortletDataContext portletDataContext, String stagedModelClassName, Serializable classPK) throws PortletDataException {
        Element referenceElement = portletDataContext.getReferenceElement(stagedModelClassName, classPK);
        StagedModelDataHandlerUtil.doImportReferenceStagedModel(portletDataContext, referenceElement, stagedModelClassName);
    }

    public static <T extends StagedModel> void importReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> stagedModelClass, Serializable classPK) throws PortletDataException {
        StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModelClass.getName(), classPK);
    }

    public static <T extends StagedModel> void importReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, String stagedModelClassName, Serializable classPK) throws PortletDataException {
        Element referenceElement = portletDataContext.getReferenceElement(referrerStagedModel, stagedModelClassName, classPK);
        StagedModelDataHandlerUtil.doImportReferenceStagedModel(portletDataContext, referenceElement, stagedModelClassName);
    }

    public static void importReferenceStagedModels(PortletDataContext portletDataContext, Class<?> stagedModelClass) throws PortletDataException {
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element referencesElement = importDataRootElement.element("references");
        if (referencesElement == null) {
            return;
        }
        List<Element> referenceElements = referencesElement.elements();
        for (Element referenceElement : referenceElements) {
            StagedModelDataHandler<?> stagedModelDataHandler;
            String className = referenceElement.attributeValue("class-name");
            String stagedModelClassName = stagedModelClass.getName();
            if (!stagedModelClassName.equals(className) || (stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModelClassName)) == null) continue;
            if (portletDataContext.isMissingReference(referenceElement)) {
                stagedModelDataHandler.importMissingReference(portletDataContext, referenceElement);
                continue;
            }
            StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceElement);
        }
    }

    public static <T extends StagedModel> void importReferenceStagedModels(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> stagedModelClass) throws PortletDataException {
        List<Element> referenceElements = portletDataContext.getReferenceElements(referrerStagedModel, stagedModelClass);
        for (Element referenceElement : referenceElements) {
            String classPK = GetterUtil.getString(referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModelClass, (Serializable)((Object)classPK));
        }
    }

    public static void importStagedModel(PortletDataContext portletDataContext, Element element) throws PortletDataException {
        StagedModel stagedModel = StagedModelDataHandlerUtil._getStagedModel(portletDataContext, element);
        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> void importStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return;
        }
        stagedModelDataHandler.importStagedModel(portletDataContext, stagedModel);
        LastSessionRecorderHelperUtil.syncLastSessionState();
    }

    protected static void doImportReferenceStagedModel(PortletDataContext portletDataContext, Element referenceElement, String stagedModelClassName) throws PortletDataException {
        String elementPath;
        StagedModel stagedModel;
        Element missingReferenceElement;
        if (referenceElement == null) {
            return;
        }
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModelClassName);
        if (stagedModelDataHandler == null) {
            return;
        }
        if (portletDataContext.isMissingReference(referenceElement)) {
            stagedModelDataHandler.importMissingReference(portletDataContext, referenceElement);
            return;
        }
        Attribute missingAttribute = referenceElement.attribute("missing");
        if (missingAttribute != null && GetterUtil.getBoolean(missingAttribute.getValue()) && (missingReferenceElement = portletDataContext.getMissingReferenceElement(stagedModel = StagedModelDataHandlerUtil._getReferenceStagedModel(portletDataContext, referenceElement))) != null && Validator.isNotNull(elementPath = missingReferenceElement.attributeValue("element-path"))) {
            Element importDataRootElement = portletDataContext.getImportDataRootElement();
            try {
                Document document = SAXReaderUtil.read(portletDataContext.getZipEntryAsString(elementPath));
                portletDataContext.setImportDataRootElement(document.getRootElement());
                StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceElement);
            }
            catch (DocumentException documentException) {
                throw new RuntimeException(documentException);
            }
            finally {
                portletDataContext.setImportDataRootElement(importDataRootElement);
            }
            return;
        }
        try {
            StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceElement);
            return;
        }
        catch (PortletDataException portletDataException) {
            if (!(portletDataException.getCause() instanceof NullPointerException)) {
                throw portletDataException;
            }
            Element importDataRootElement = portletDataContext.getImportDataRootElement();
            try {
                ZipReader zipReader = portletDataContext.getZipReader();
                List<String> entries = zipReader.getEntries();
                Iterator<String> iterator = entries.iterator();
                StagedModel stagedModel2 = StagedModelDataHandlerUtil._getStagedModel(portletDataContext, referenceElement);
                while (iterator.hasNext()) {
                    String entry = iterator.next();
                    if (!entry.endsWith(".xml") || !StagedModelDataHandlerUtil._containsStagedModel(portletDataContext, entry, stagedModel2)) continue;
                    try {
                        Document document = SAXReaderUtil.read(portletDataContext.getZipEntryAsString(entry));
                        portletDataContext.setImportDataRootElement(document.getRootElement());
                        String path = ExportImportPathUtil.getModelPath(stagedModel2);
                        portletDataContext.removePrimaryKey(path);
                        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceElement);
                        return;
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug(exception);
                    }
                }
                PortletDataException portletDataException2 = new PortletDataException();
                portletDataException2.setStagedModel(stagedModel2);
                portletDataException2.setType(14);
                throw portletDataException2;
            }
            finally {
                portletDataContext.setImportDataRootElement(importDataRootElement);
            }
        }
    }

    private static boolean _containsStagedModel(PortletDataContext portletDataContext, String path, StagedModel stagedModel) {
        block3: {
            XMLInputFactory xmlInputFactory = SecureXMLFactoryProviderUtil.newXMLInputFactory();
            try {
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(portletDataContext.getZipEntryAsInputStream(path));
                Class<?> modelClass = stagedModel.getModelClass();
                String simpleName = modelClass.getSimpleName();
                while (xmlStreamReader.hasNext()) {
                    QName qName;
                    int event = xmlStreamReader.next();
                    if (event != 1 || !Objects.equals((qName = xmlStreamReader.getName()).getLocalPart(), simpleName)) continue;
                    return true;
                }
            }
            catch (XMLStreamException xmlStreamException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(xmlStreamException);
            }
        }
        return false;
    }

    private static StagedModel _getReferenceStagedModel(PortletDataContext portletDataContext, Element element) {
        String classPK;
        String className;
        long groupId = GetterUtil.getLong(element.attributeValue("group-id"));
        String path = ExportImportPathUtil.getModelPath(groupId, className = element.attributeValue("class-name"), (Serializable)((Object)(classPK = GetterUtil.getString(element.attributeValue("class-pk")))));
        StagedModel stagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
        if (stagedModel != null) {
            return stagedModel;
        }
        path = ExportImportPathUtil.getCompanyModelPath(portletDataContext.getSourceCompanyId(), className, (Serializable)((Object)classPK));
        return (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
    }

    private static StagedModel _getStagedModel(PortletDataContext portletDataContext, Element element) {
        StagedModel stagedModel = null;
        String elementName = element.getName();
        if (elementName.equals("reference")) {
            stagedModel = StagedModelDataHandlerUtil._getReferenceStagedModel(portletDataContext, element);
        } else {
            String path = element.attributeValue("path");
            stagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
        }
        return stagedModel;
    }

    private static <T extends StagedModel> StagedModelDataHandler<T> _getStagedModelDataHandler(T stagedModel) {
        if (stagedModel == null) {
            _log.error("Unable to get a staged model data handler for a null value because a model was not exported properly");
            return null;
        }
        return StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(ExportImportClassedModelUtil.getClassName(stagedModel));
    }
}

