/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderBeanHandler
implements InvocationHandler {
    private final Object _bean;
    private final ClassLoader _classLoader;

    public ClassLoaderBeanHandler(Object bean, ClassLoader classLoader) {
        this._bean = bean;
        this._classLoader = classLoader;
    }

    public Object getBean() {
        return this._bean;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        ClassLoader classLoader = this._classLoader;
        if (classLoader == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)classLoader);){
            String methodName;
            if (method.getDeclaringClass() == Object.class && (methodName = method.getName()).equals("equals")) {
                if (proxy == arguments[0]) {
                    Boolean bl = true;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
            Object object = method.invoke(this._bean, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }
}

