/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.DynamicPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.util.ProxyFactory;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class DynamicPortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    private static final PortalCacheManager<? extends Serializable, ?> _DUMMY_PORTAL_CACHE_MANAGER = ProxyFactory.newDummyInstance(PortalCacheManager.class);
    private final Map<String, DynamicPortalCache<K, V>> _dynamicPortalCaches = new ConcurrentHashMap<String, DynamicPortalCache<K, V>>();
    private volatile PortalCacheManager<K, V> _portalCacheManager;
    private final Set<PortalCacheManagerListener> _portalCacheManagerListeners = new CopyOnWriteArraySet<PortalCacheManagerListener>();
    private final String _portalCacheManagerName;

    public DynamicPortalCacheManager(String portalCacheManagerName) {
        this._portalCacheManagerName = portalCacheManagerName;
        this._portalCacheManager = _DUMMY_PORTAL_CACHE_MANAGER;
    }

    @Override
    public void clearAll() throws PortalCacheException {
        this._portalCacheManager.clearAll();
    }

    @Override
    public void destroy() {
        this._dynamicPortalCaches.clear();
    }

    @Override
    public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
        return this._dynamicPortalCaches.computeIfAbsent(portalCacheName, key -> {
            PortalCache<K, V> portalCache = this._portalCacheManager.fetchPortalCache(portalCacheName);
            if (portalCache == null) {
                return null;
            }
            return new DynamicPortalCache<K, V>(this, portalCache, (String)key, portalCache.isMVCC(), portalCache.isSharded());
        });
    }

    @Override
    public PortalCache<K, V> getPortalCache(String portalCacheName) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, false);
    }

    @Override
    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, mvcc, false);
    }

    @Override
    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc, boolean sharded) throws PortalCacheException {
        return this._dynamicPortalCaches.computeIfAbsent(portalCacheName, key -> new DynamicPortalCache<K, V>(this, this._portalCacheManager.getPortalCache((String)key, mvcc, sharded), (String)key, mvcc, sharded));
    }

    @Override
    public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
        PortalCacheManager<K, V> portalCacheManager = this._portalCacheManager;
        if (portalCacheManager == _DUMMY_PORTAL_CACHE_MANAGER) {
            return Collections.unmodifiableSet(this._portalCacheManagerListeners);
        }
        return portalCacheManager.getPortalCacheManagerListeners();
    }

    @Override
    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    @Override
    public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        PortalCacheManager<K, V> portalCacheManager = this._portalCacheManager;
        if (portalCacheManager == _DUMMY_PORTAL_CACHE_MANAGER) {
            throw new UnsupportedOperationException("This method is not supported because real portal cache manager is missing now, please retry later");
        }
        portalCacheManager.reconfigurePortalCaches(configurationURL, classLoader);
    }

    @Override
    public boolean registerPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        PortalCacheManager<K, V> portalCacheManager = this._portalCacheManager;
        if (portalCacheManager == _DUMMY_PORTAL_CACHE_MANAGER || portalCacheManager.registerPortalCacheManagerListener(portalCacheManagerListener)) {
            this._portalCacheManagerListeners.add(portalCacheManagerListener);
            return true;
        }
        return false;
    }

    @Override
    public void removePortalCache(String portalCacheName) {
        this._dynamicPortalCaches.remove(portalCacheName);
        this._portalCacheManager.removePortalCache(portalCacheName);
    }

    @Override
    public void removePortalCaches(long companyId) {
        this._portalCacheManager.removePortalCaches(companyId);
    }

    @Override
    public boolean unregisterPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        PortalCacheManager<K, V> portalCacheManager = this._portalCacheManager;
        if (portalCacheManager == _DUMMY_PORTAL_CACHE_MANAGER || portalCacheManager.unregisterPortalCacheManagerListener(portalCacheManagerListener)) {
            this._portalCacheManagerListeners.remove(portalCacheManagerListener);
            return true;
        }
        return false;
    }

    @Override
    public void unregisterPortalCacheManagerListeners() {
        this._portalCacheManager.unregisterPortalCacheManagerListeners();
        this._portalCacheManagerListeners.clear();
    }

    protected PortalCacheManager<K, V> getPortalCacheManager() {
        return this._portalCacheManager;
    }

    protected void setPortalCacheManager(PortalCacheManager<? extends Serializable, ?> portalCacheManager) {
        if (this._portalCacheManager == portalCacheManager) {
            return;
        }
        if (portalCacheManager == null) {
            portalCacheManager = _DUMMY_PORTAL_CACHE_MANAGER;
        }
        this._portalCacheManager = portalCacheManager;
        for (PortalCacheManagerListener portalCacheManagerListener : this._portalCacheManagerListeners) {
            this._portalCacheManager.registerPortalCacheManagerListener(portalCacheManagerListener);
        }
        for (DynamicPortalCache dynamicPortalCache : this._dynamicPortalCaches.values()) {
            dynamicPortalCache.setPortalCache(this._portalCacheManager.getPortalCache(dynamicPortalCache.getPortalCacheName(), dynamicPortalCache.isMVCC(), dynamicPortalCache.isSharded()));
        }
    }
}

