/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.DynamicPortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PortalCacheManagerProvider {
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final Map<String, DynamicPortalCacheManager<? extends Serializable, ?>> _dynamicPortalCacheManagers = new ConcurrentHashMap();
    private static final ServiceTracker<PortalCacheManager<? extends Serializable, ?>, DynamicPortalCacheManager<? extends Serializable, ?>> _serviceTracker = new ServiceTracker(_bundleContext, PortalCacheManager.class, (ServiceTrackerCustomizer)new PortalCacheProviderServiceTrackerCustomizer());

    public static PortalCacheManager<? extends Serializable, ?> getPortalCacheManager(String portalCacheManagerName) {
        return _dynamicPortalCacheManagers.computeIfAbsent(portalCacheManagerName, key -> new DynamicPortalCacheManager((String)key));
    }

    public static Collection<PortalCacheManager<? extends Serializable, ?>> getPortalCacheManagers() {
        return Collections.unmodifiableCollection(_dynamicPortalCacheManagers.values());
    }

    static {
        _serviceTracker.open();
    }

    private static class PortalCacheProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalCacheManager<? extends Serializable, ?>, DynamicPortalCacheManager<? extends Serializable, ?>> {
        private PortalCacheProviderServiceTrackerCustomizer() {
        }

        public DynamicPortalCacheManager<? extends Serializable, ?> addingService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference) {
            PortalCacheManager portalCacheManager = (PortalCacheManager)_bundleContext.getService(serviceReference);
            DynamicPortalCacheManager dynamicPortalCacheManager = _dynamicPortalCacheManagers.computeIfAbsent(portalCacheManager.getPortalCacheManagerName(), key -> new DynamicPortalCacheManager((String)key));
            dynamicPortalCacheManager.setPortalCacheManager(portalCacheManager);
            return dynamicPortalCacheManager;
        }

        public void modifiedService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference, DynamicPortalCacheManager<? extends Serializable, ?> dynamicPortalCacheManager) {
        }

        public void removedService(ServiceReference<PortalCacheManager<? extends Serializable, ?>> serviceReference, DynamicPortalCacheManager<? extends Serializable, ?> dynamicPortalCacheManager) {
            _bundleContext.ungetService(serviceReference);
            dynamicPortalCacheManager.setPortalCacheManager(null);
        }
    }
}

