/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.comment;

import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public abstract class BaseDiscussionPermission
implements DiscussionPermission {
    @Override
    public void checkAddPermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!this.hasAddPermission(permissionChecker, companyId, groupId, className, classPK)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, "ADD_DISCUSSION");
        }
    }

    @Override
    public void checkDeletePermission(PermissionChecker permissionChecker, long commentId) throws PortalException {
        if (!this.hasDeletePermission(permissionChecker, commentId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, "DELETE_DISCUSSION");
        }
    }

    @Override
    public void checkSubscribePermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!this.hasSubscribePermission(permissionChecker, companyId, groupId, className, classPK)) {
            throw new PrincipalException();
        }
    }

    @Override
    public void checkUpdatePermission(PermissionChecker permissionChecker, long commentId) throws PortalException {
        if (!this.hasUpdatePermission(permissionChecker, commentId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, "UPDATE_DISCUSSION");
        }
    }

    @Override
    public void checkViewPermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!this.hasViewPermission(permissionChecker, companyId, groupId, className, classPK)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, "VIEW");
        }
    }

    @Override
    public boolean hasDeletePermission(PermissionChecker permissionChecker, long commentId) throws PortalException {
        return this.hasPermission(permissionChecker, commentId, "DELETE_DISCUSSION");
    }

    @Override
    public boolean hasUpdatePermission(PermissionChecker permissionChecker, long commentId) throws PortalException {
        return this.hasPermission(permissionChecker, commentId, "UPDATE_DISCUSSION");
    }
}

