/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.SystemProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SystemExecutorServiceUtil {
    private static final ExecutorService _executorService;

    public static ExecutorService getExecutorService() {
        return _executorService;
    }

    public static <T> Callable<T> renameThread(Callable<T> callable, String taskName) {
        return () -> {
            Thread currentThread = Thread.currentThread();
            String name = currentThread.getName();
            currentThread.setName(StringBundler.concat((String[])new String[]{name, "-", taskName}));
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                currentThread.setName(name);
            }
        };
    }

    public static Runnable renameThread(Runnable runnable, String taskName) {
        return () -> {
            Thread currentThread = Thread.currentThread();
            String name = currentThread.getName();
            currentThread.setName(StringBundler.concat((String[])new String[]{name, "-", taskName}));
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(name);
            }
        };
    }

    public static void shutdown() throws InterruptedException {
        _executorService.shutdownNow();
        long shutdownTimeout = GetterUtil.getLong(SystemProperties.get("system.executor.service.shutdown.timeout"), 60L);
        _executorService.awaitTermination(shutdownTimeout, TimeUnit.SECONDS);
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        int defaultMaxPoolSize = runtime.availableProcessors();
        if (defaultMaxPoolSize == 1) {
            defaultMaxPoolSize = 2;
        }
        int maxPoolSize = GetterUtil.getInteger(SystemProperties.get("system.executor.service.maxpoolsize"), defaultMaxPoolSize);
        long keepAliveTime = GetterUtil.getLong(SystemProperties.get("system.executor.service.keepalivetime"), 60L);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(maxPoolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(SystemExecutorServiceUtil.class.getSimpleName(), 5, null), new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        _executorService = threadPoolExecutor;
    }
}

