/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseDBFactory
implements DBFactory {
    private final ConcurrentMap<String, DB> _dbs = new ConcurrentHashMap<String, DB>();

    @Override
    public DB create(int dbMajorVersion, int dbMinorVersion) {
        DB previousDB;
        String minorVersion;
        String majorVersion = StringUtil.toHexString(dbMajorVersion);
        String version = StringBundler.concat((String[])new String[]{majorVersion, "#", minorVersion = StringUtil.toHexString(dbMinorVersion)});
        DB db = (DB)this._dbs.get(version);
        if (db == null && (previousDB = this._dbs.putIfAbsent(version, db = this.doCreate(dbMajorVersion, dbMinorVersion))) != null) {
            db = previousDB;
        }
        return db;
    }

    protected abstract DB doCreate(int var1, int var2);
}

