/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface DB {
    public static final int SQL_SIZE_NONE = -1;
    public static final int SQL_VARCHAR_MAX_SIZE = Integer.MAX_VALUE;
    public static final int SQL_VARCHAR_MAX_SIZE_THRESHOLD = 9999999;

    public void addIndexes(Connection var1, List<IndexMetadata> var2) throws IOException, SQLException;

    public void alterColumnName(Connection var1, String var2, String var3, String var4) throws Exception;

    public void alterColumnType(Connection var1, String var2, String var3, String var4) throws Exception;

    public void alterTableAddColumn(Connection var1, String var2, String var3, String var4) throws Exception;

    public void alterTableDropColumn(Connection var1, String var2, String var3) throws Exception;

    public String buildSQL(String var1) throws IOException, SQLException;

    public void copyTableRows(Connection var1, String var2, String var3, Map<String, String> var4, Map<String, String> var5) throws Exception;

    public void copyTableStructure(Connection var1, String var2, String var3) throws Exception;

    public List<IndexMetadata> dropIndexes(Connection var1, String var2, String var3) throws IOException, SQLException;

    public DBType getDBType();

    public String getDefaultValue(String var1);

    public List<Index> getIndexes(Connection var1) throws SQLException;

    public List<IndexMetadata> getIndexMetadatas(Connection var1, String var2, String var3, boolean var4) throws SQLException;

    public ResultSet getIndexResultSet(Connection var1, String var2, boolean var3) throws SQLException;

    public int getMajorVersion();

    public int getMinorVersion();

    default public String getNewUuidFunctionName() {
        return null;
    }

    public String getPopulateSQL(String var1, String var2);

    public String[] getPrimaryKeyColumnNames(Connection var1, String var2) throws SQLException;

    public String getRecreateSQL(String var1);

    public Integer getSQLType(String var1);

    public Integer getSQLTypeDecimalDigits(String var1);

    public Integer getSQLTypeSize(String var1);

    public String getTemplateBlob();

    public String getTemplateFalse();

    public String getTemplateTrue();

    public String getVersionString();

    public boolean isSupportsAlterColumnName();

    public boolean isSupportsAlterColumnType();

    public boolean isSupportsDBPartition();

    public boolean isSupportsInlineDistinct();

    default public boolean isSupportsNewUuidFunction() {
        return false;
    }

    public boolean isSupportsQueryingAfterException();

    public boolean isSupportsScrollableResults();

    public boolean isSupportsStringCaseSensitiveQuery();

    public boolean isSupportsUpdateWithInnerJoin();

    public void process(UnsafeConsumer<Long, Exception> var1) throws Exception;

    public void removePrimaryKey(Connection var1, String var2) throws Exception;

    public void renameTables(Connection var1, ObjectValuePair<String, String> ... var2) throws Exception;

    default public void runSQL(Connection connection, DBTypeToSQLMap dbTypeToSQLMap) throws IOException, SQLException {
        String sql = dbTypeToSQLMap.get(this.getDBType());
        this.runSQL(connection, new String[]{sql});
    }

    public void runSQL(Connection var1, String var2) throws IOException, SQLException;

    public void runSQL(Connection var1, String[] var2) throws IOException, SQLException;

    default public void runSQL(DBTypeToSQLMap dbTypeToSQLMap) throws IOException, SQLException {
        String sql = dbTypeToSQLMap.get(this.getDBType());
        this.runSQL(new String[]{sql});
    }

    public void runSQL(String var1) throws IOException, SQLException;

    public void runSQL(String[] var1) throws IOException, SQLException;

    public void runSQLTemplate(Connection var1, String var2, boolean var3) throws IOException, NamingException, SQLException;

    public void runSQLTemplate(String var1, boolean var2) throws IOException, NamingException, SQLException;

    @Deprecated
    default public void runSQLTemplateString(Connection connection, String template, boolean failOnError) throws IOException, NamingException, SQLException {
        this.runSQLTemplate(connection, template, failOnError);
    }

    @Deprecated
    default public void runSQLTemplateString(String template, boolean failOnError) throws IOException, NamingException, SQLException {
        this.runSQLTemplate(template, failOnError);
    }

    public void setSupportsStringCaseSensitiveQuery(boolean var1);

    public AutoCloseable syncTables(Connection var1, String var2, String var3, Map<String, String> var4, Map<String, String> var5) throws Exception;

    public void updateIndexes(Connection var1, String var2, String var3, boolean var4) throws Exception;
}

