/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSenderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;

public class IndexableActionableDynamicQuery
extends DefaultActionableDynamicQuery {
    private static final long _STATUS_INTERVAL = 100L;
    private static final Snapshot<IndexWriterHelper> _indexWriterHelperProxySnapshot = new Snapshot<IndexWriterHelper>(IndexableActionableDynamicQuery.class, IndexWriterHelper.class);
    private long _count;
    private Collection<Document> _documents = new ArrayList<Document>();
    private long _total;

    public void addDocuments(Document ... documents) throws PortalException {
        if (ArrayUtil.isEmpty(documents)) {
            return;
        }
        for (Document document : documents) {
            if (document == null) continue;
            this._documents.add(document);
        }
        long size = this._documents.size();
        if (size >= (long)this.getInterval()) {
            this.indexInterval();
        } else if (size % 100L == 0L) {
            this.sendStatusMessage(size);
        }
    }

    @Override
    public void performActions() throws PortalException {
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            this._total = super.performCount();
        }
        try {
            super.performActions();
        }
        finally {
            this._count = this._total;
            this.sendStatusMessage();
        }
    }

    @Override
    public void setParallel(boolean parallel) {
        if (this.isParallel() == parallel) {
            return;
        }
        super.setParallel(parallel);
        if (parallel) {
            this._documents = new ConcurrentLinkedDeque<Document>();
        }
    }

    @Override
    protected void actionsCompleted() throws PortalException {
        IndexWriterHelper indexWriterHelper = _indexWriterHelperProxySnapshot.get();
        indexWriterHelper.commit(this.getCompanyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doPerformActions(long previousPrimaryKey) throws PortalException {
        try {
            long l = super.doPerformActions(previousPrimaryKey);
            return l;
        }
        finally {
            this.indexInterval();
        }
    }

    protected void indexInterval() throws PortalException {
        if (this._documents == null || this._documents.isEmpty()) {
            return;
        }
        IndexWriterHelper indexWriterHelper = _indexWriterHelperProxySnapshot.get();
        indexWriterHelper.updateDocuments(this.getCompanyId(), new ArrayList<Document>(this._documents), false);
        this._count += (long)this._documents.size();
        this._documents.clear();
        this.sendStatusMessage();
    }

    @Override
    protected void performAction(Object object) throws PortalException {
        long ctCollectionId = 0L;
        if (object instanceof CTModel) {
            CTModel ctModel = (CTModel)object;
            ctCollectionId = ctModel.getCtCollectionId();
        }
        try (SafeCloseable safeCloseable1 = CTSQLModeThreadLocal.setCTSQLModeWithSafeCloseable(CTSQLModeThreadLocal.CTSQLMode.DEFAULT);
             SafeCloseable safeCloseable2 = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable(ctCollectionId);){
            super.performAction(object);
        }
    }

    protected void sendStatusMessage() {
        this.sendStatusMessage(0L);
    }

    protected void sendStatusMessage(long documentIntervalCount) {
        if (!BackgroundTaskThreadLocal.hasBackgroundTask()) {
            return;
        }
        Class<?> modelClass = this.getModelClass();
        ReindexStatusMessageSenderUtil.sendStatusMessage(modelClass.getName(), this._count + documentIntervalCount, this._total);
    }
}

