/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class LocaleException
extends PortalException {
    public static final int TYPE_CONTENT = 3;
    public static final int TYPE_DEFAULT = 4;
    public static final int TYPE_DISPLAY_SETTINGS = 1;
    public static final int TYPE_EXPORT_IMPORT = 2;
    private Collection<String> _sourceAvailableLanguageIds;
    private Collection<Locale> _sourceAvailableLocales;
    private Collection<String> _targetAvailableLanguageIds;
    private Collection<Locale> _targetAvailableLocales;
    private final int _type;

    public LocaleException() {
        this._type = 0;
    }

    public LocaleException(int type) {
        this._type = type;
    }

    public LocaleException(int type, String msg) {
        super(msg);
        this._type = type;
    }

    public LocaleException(int type, String msg, Throwable throwable) {
        super(msg, throwable);
        this._type = type;
    }

    public LocaleException(int type, Throwable throwable) {
        super(throwable);
        this._type = type;
    }

    public Collection<String> getSourceAvailableLanguageIds() {
        if (this._sourceAvailableLanguageIds != null) {
            return this._sourceAvailableLanguageIds;
        }
        this._sourceAvailableLanguageIds = this._toLanguageIds(this._sourceAvailableLocales);
        return this._sourceAvailableLanguageIds;
    }

    public Collection<Locale> getSourceAvailableLocales() {
        if (this._sourceAvailableLocales != null) {
            return this._sourceAvailableLocales;
        }
        this._sourceAvailableLocales = this._toLocales(this._sourceAvailableLanguageIds);
        return this._sourceAvailableLocales;
    }

    public Collection<String> getTargetAvailableLanguageIds() {
        if (this._targetAvailableLanguageIds != null) {
            return this._targetAvailableLanguageIds;
        }
        this._targetAvailableLanguageIds = this._toLanguageIds(this._targetAvailableLocales);
        return this._targetAvailableLanguageIds;
    }

    public Collection<Locale> getTargetAvailableLocales() {
        if (this._targetAvailableLocales != null) {
            return this._targetAvailableLocales;
        }
        this._targetAvailableLocales = this._toLocales(this._targetAvailableLanguageIds);
        return this._targetAvailableLocales;
    }

    public int getType() {
        return this._type;
    }

    public void setSourceAvailableLanguageIds(Collection<String> sourceAvailableLanguageIds) {
        this._sourceAvailableLanguageIds = sourceAvailableLanguageIds;
        this._sourceAvailableLocales = null;
    }

    public void setSourceAvailableLocales(Collection<Locale> sourceAvailableLocales) {
        this._sourceAvailableLanguageIds = null;
        this._sourceAvailableLocales = sourceAvailableLocales;
    }

    public void setTargetAvailableLanguageIds(Collection<String> targetAvailableLanguageIds) {
        this._targetAvailableLanguageIds = targetAvailableLanguageIds;
        this._targetAvailableLocales = null;
    }

    public void setTargetAvailableLocales(Collection<Locale> targetAvailableLocales) {
        this._targetAvailableLanguageIds = null;
        this._targetAvailableLocales = targetAvailableLocales;
    }

    private Collection<String> _toLanguageIds(Collection<Locale> locales) {
        if (locales == null) {
            return null;
        }
        ArrayList<String> languageIds = new ArrayList<String>(locales.size());
        for (Locale locale : locales) {
            languageIds.add(String.valueOf(locale));
        }
        return languageIds;
    }

    private Collection<Locale> _toLocales(Collection<String> languageIds) {
        if (languageIds == null) {
            return null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>(languageIds.size());
        for (String languageId : languageIds) {
            locales.add(LocaleUtil.fromLanguageId(languageId, false));
        }
        return locales;
    }
}

