/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.frontend.source.map;

import com.liferay.petra.string.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrontendSourceMapUtil {
    private static final Pattern _cssPattern = Pattern.compile("\\/\\*#\\s*sourceMappingURL=.+?\\.css\\.map\\s*\\*\\/");
    private static final Pattern _jsPattern = Pattern.compile("\\/\\/#\\s*sourceMappingURL=.+?\\.js\\.map$");

    public static String stripCSSSourceMapping(String text) {
        if (text == null) {
            return text;
        }
        Matcher matcher = _cssPattern.matcher(text);
        return matcher.replaceAll("");
    }

    public static String stripJSSourceMapping(String text) {
        if (text == null) {
            return text;
        }
        Matcher matcher = _jsPattern.matcher(text);
        return matcher.replaceAll("");
    }

    public static void transferCSS(InputStream inputStream, OutputStream outputStream) throws IOException {
        String text = StringUtil.read((InputStream)inputStream);
        if (text != null) {
            text = FrontendSourceMapUtil.stripCSSSourceMapping(text);
            outputStream.write(text.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void transferJS(InputStream inputStream, OutputStream outputStream) throws IOException {
        String text = StringUtil.read((InputStream)inputStream);
        if (text != null) {
            text = FrontendSourceMapUtil.stripJSSourceMapping(text);
            outputStream.write(text.getBytes(StandardCharsets.UTF_8));
        }
    }
}

