/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jndi;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import javax.naming.Context;
import javax.naming.NamingException;

public class JNDIUtil {
    private static final Log _log = LogFactoryUtil.getLog(JNDIUtil.class);

    public static Object lookup(Context context, String location) throws NamingException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        HashSet<ClassLoader> familyClassLoaders = new HashSet<ClassLoader>();
        ClassLoader classLoader = contextClassLoader;
        do {
            familyClassLoaders.add(classLoader);
        } while ((classLoader = classLoader.getParent()) != null);
        ArrayList<ClassLoader> lookupClassLoaders = new ArrayList<ClassLoader>();
        classLoader = contextClassLoader;
        do {
            lookupClassLoaders.add(classLoader);
            Class<?> clazz = classLoader.getClass();
            ClassLoader declaringClassLoader = clazz.getClassLoader();
            if (!familyClassLoaders.contains(declaringClassLoader)) {
                lookupClassLoaders.add(declaringClassLoader);
            }
            if (!(classLoader instanceof AggregateClassLoader)) continue;
            AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)classLoader;
            for (ClassLoader currentClassLoader : aggregateClassLoader.getClassLoaders()) {
                if (familyClassLoaders.contains(currentClassLoader)) continue;
                lookupClassLoaders.add(currentClassLoader);
            }
        } while ((classLoader = classLoader.getParent()) != null);
        NamingException namingException1 = null;
        for (ClassLoader lookupClassLoader : lookupClassLoaders) {
            try {
                return JNDIUtil._lookup(context, location, lookupClassLoader);
            }
            catch (NamingException namingException2) {
                if (namingException1 == null) {
                    namingException1 = namingException2;
                    continue;
                }
                namingException1.addSuppressed(namingException2);
            }
        }
        throw namingException1;
    }

    private static Object _lookup(Context context, String location) throws NamingException {
        if (_log.isDebugEnabled()) {
            _log.debug("Lookup " + location);
        }
        Object object = null;
        try {
            object = context.lookup(location);
        }
        catch (NamingException namingException1) {
            if (location.contains("java:comp/env/")) {
                try {
                    String newLocation = StringUtil.removeSubstring(location, "java:comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
                catch (NamingException namingException2) {
                    String newLocation = StringUtil.removeSubstring(location, "comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
            }
            if (location.contains("java:")) {
                try {
                    String newLocation = StringUtil.removeSubstring(location, "java:");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
                catch (NamingException namingException2) {
                    String newLocation = StringUtil.replace(location, "java:", "java:comp/env/");
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
            }
            if (!location.contains("java:")) {
                try {
                    String newLocation = "java:" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException1.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
                catch (NamingException namingException2) {
                    String newLocation = "java:comp/env/" + location;
                    if (_log.isDebugEnabled()) {
                        _log.debug(namingException2.getMessage());
                        _log.debug("Attempt " + newLocation);
                    }
                    object = context.lookup(newLocation);
                }
            }
            throw new NamingException();
        }
        return object;
    }

    private static Object _lookup(Context context, String location, ClassLoader classLoader) throws NamingException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)classLoader);){
            Object object = JNDIUtil._lookup(context, location);
            return object;
        }
    }
}

