/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;

public class InvokerMessageListener
implements MessageListener {
    private final ClassLoader _classLoader;
    private final MessageListener _messageListener;

    public InvokerMessageListener(MessageListener messageListener) {
        this(messageListener, Thread.currentThread().getContextClassLoader());
    }

    public InvokerMessageListener(MessageListener messageListener, ClassLoader classLoader) {
        this._messageListener = messageListener;
        this._classLoader = classLoader;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InvokerMessageListener)) {
            return false;
        }
        InvokerMessageListener messageListenerInvoker = (InvokerMessageListener)object;
        return this._messageListener.equals(messageListenerInvoker.getMessageListener());
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public MessageListener getMessageListener() {
        return this._messageListener;
    }

    public int hashCode() {
        return this._messageListener.hashCode();
    }

    @Override
    public void receive(Message message) throws MessageListenerException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this._classLoader);){
            this._messageListener.receive(message);
        }
    }

    public String toString() {
        return this._messageListener.toString();
    }
}

