/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.module.service.Snapshot;

public class MessageBusUtil {
    private static final Snapshot<MessageBus> _messageBusSnapshot = new Snapshot<MessageBus>(MessageBusUtil.class, MessageBus.class);

    public static Destination getDestination(String destinationName) {
        MessageBus messageBus = _messageBusSnapshot.get();
        return messageBus.getDestination(destinationName);
    }

    public static MessageBus getMessageBus() {
        return _messageBusSnapshot.get();
    }

    public static void sendMessage(String destinationName, Message message) {
        MessageBus messageBus = _messageBusSnapshot.get();
        messageBus.sendMessage(destinationName, message);
    }

    public static void sendMessage(String destinationName, Object payload) {
        MessageBus messageBus = _messageBusSnapshot.get();
        Message message = new Message();
        message.setPayload(payload);
        messageBus.sendMessage(destinationName, message);
    }
}

