/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.mobile.device;

import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceRecognitionProvider;
import com.liferay.portal.kernel.mobile.device.KnownDevices;
import com.liferay.portal.kernel.mobile.device.NoKnownDevices;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import com.liferay.portal.kernel.module.service.Snapshot;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DeviceDetectionUtil {
    private static final Snapshot<DeviceRecognitionProvider> _deviceRecognitionProviderSnapshot = new Snapshot<DeviceRecognitionProvider>(DeviceDetectionUtil.class, DeviceRecognitionProvider.class);

    public static Device detectDevice(HttpServletRequest httpServletRequest) {
        DeviceRecognitionProvider deviceRecognitionProvider = _deviceRecognitionProviderSnapshot.get();
        if (deviceRecognitionProvider == null) {
            return UnknownDevice.getInstance();
        }
        return deviceRecognitionProvider.detectDevice(httpServletRequest);
    }

    public static DeviceRecognitionProvider getDeviceRecognitionProvider() {
        return _deviceRecognitionProviderSnapshot.get();
    }

    public static Set<VersionableName> getKnownBrands() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getBrands();
    }

    public static Set<VersionableName> getKnownBrowsers() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getBrowsers();
    }

    public static Set<VersionableName> getKnownOperatingSystems() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getOperatingSystems();
    }

    public static Set<String> getKnownPointingMethods() {
        KnownDevices knownDevices = DeviceDetectionUtil.getKnownDevices();
        return knownDevices.getPointingMethods();
    }

    protected static KnownDevices getKnownDevices() {
        DeviceRecognitionProvider deviceRecognitionProvider = _deviceRecognitionProviderSnapshot.get();
        if (deviceRecognitionProvider == null) {
            return NoKnownDevices.getInstance();
        }
        return deviceRecognitionProvider.getKnownDevices();
    }
}

