/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.mobile.device;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class VersionableName
implements Comparable<VersionableName>,
Serializable {
    public static final VersionableName UNKNOWN = new VersionableName("unknown", "unknown");
    private final String _name;
    private Set<String> _versions;

    public VersionableName(String name) {
        this(name, (Set<String>)null);
    }

    public VersionableName(String name, Set<String> versions) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException("Name is null");
        }
        this._name = name;
        this._versions = versions;
    }

    public VersionableName(String name, String version) {
        this(name, new HashSet<String>());
        this.addVersion(version);
    }

    public void addVersion(String version) {
        if (version == null) {
            return;
        }
        if (this._versions == null) {
            this._versions = new TreeSet<String>();
        }
        this._versions.add(version);
    }

    @Override
    public int compareTo(VersionableName versionableName) {
        String upperCaseName = StringUtil.toUpperCase(this._name);
        return upperCaseName.compareTo(StringUtil.toUpperCase(versionableName.getName()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VersionableName)) {
            return false;
        }
        VersionableName versionableName = (VersionableName)object;
        return Objects.equals(this._name, versionableName._name);
    }

    public String getName() {
        return this._name;
    }

    public Set<String> getVersions() {
        if (this._versions == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._versions);
    }

    public int hashCode() {
        if (this._name != null) {
            return this._name.hashCode();
        }
        return 0;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{name=", this._name, ", versions=", this._versions, "}"});
    }
}

