/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.service;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Snapshot<T> {
    private final Supplier<T> _serviceSupplier;

    public static <T> Class<T> cast(Class<?> clazz) {
        return clazz;
    }

    public Snapshot(Class<?> holderClass, Class<T> serviceClass) {
        this(holderClass, serviceClass, null);
    }

    public Snapshot(Class<?> holderClass, Class<T> serviceClass, String filterString) {
        this(holderClass, serviceClass, filterString, false);
    }

    public Snapshot(Class<?> holderClass, Class<T> serviceClass, String filterString, boolean dynamic) {
        if (dynamic) {
            DCLSingleton serviceTrackerDCLSingleton = new DCLSingleton();
            Supplier<ServiceTracker> serviceTrackerSupplier = () -> {
                ServiceTracker serviceTracker = null;
                BundleContext bundleContext = this._getBundleContext(holderClass);
                if (filterString == null) {
                    serviceTracker = new ServiceTracker(bundleContext, serviceClass, null);
                } else {
                    try {
                        serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", serviceClass.getName(), ")", filterString, ")"})), null);
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        return (ServiceTracker)((Object)((Object)ReflectionUtil.throwException((Throwable)invalidSyntaxException)));
                    }
                }
                serviceTracker.open();
                return serviceTracker;
            };
            this._serviceSupplier = () -> {
                ServiceTracker serviceTracker = (ServiceTracker)((Object)((Object)serviceTrackerDCLSingleton.getSingleton(serviceTrackerSupplier)));
                BundleContext bundleContext = serviceTracker.getContext();
                try {
                    bundleContext.getBundle();
                }
                catch (IllegalStateException illegalStateException) {
                    serviceTrackerDCLSingleton.destroy(null);
                    serviceTracker = (ServiceTracker)((Object)((Object)serviceTrackerDCLSingleton.getSingleton(serviceTrackerSupplier)));
                }
                return serviceTracker.getService();
            };
        } else {
            final DCLSingleton serviceDCLSingleton = new DCLSingleton();
            this._serviceSupplier = () -> serviceDCLSingleton.getSingleton(() -> {
                final BundleContext bundleContext = this._getBundleContext(holderClass);
                ServiceReference<T> serviceReference = this._getServiceReference(bundleContext, serviceClass, filterString);
                if (serviceReference == null) {
                    return null;
                }
                try {
                    bundleContext.addServiceListener(new ServiceListener(){

                        public void serviceChanged(ServiceEvent serviceEvent) {
                            if (serviceEvent.getType() == 4) {
                                serviceDCLSingleton.destroy(null);
                                bundleContext.removeServiceListener((ServiceListener)this);
                            }
                        }
                    }, StringBundler.concat((Object[])new Object[]{"(", "service.id", "=", serviceReference.getProperty("service.id"), ")"}));
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    return ReflectionUtil.throwException((Throwable)invalidSyntaxException);
                }
                return bundleContext.getService(serviceReference);
            });
        }
    }

    public T get() {
        return this._serviceSupplier.get();
    }

    private BundleContext _getBundleContext(Class<?> holderClass) {
        Bundle bundle = FrameworkUtil.getBundle(holderClass);
        if (bundle == null) {
            return SystemBundleUtil.getBundleContext();
        }
        return bundle.getBundleContext();
    }

    private ServiceReference<T> _getServiceReference(BundleContext bundleContext, Class<T> serviceClass, String filterString) {
        if (filterString == null) {
            return bundleContext.getServiceReference(serviceClass);
        }
        try {
            Collection serviceReferences = bundleContext.getServiceReferences(serviceClass, filterString);
            if (serviceReferences.isEmpty()) {
                return null;
            }
            Iterator iterator = serviceReferences.iterator();
            return (ServiceReference)iterator.next();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return (ServiceReference)ReflectionUtil.throwException((Throwable)invalidSyntaxException);
        }
    }

    private static class ServiceTracker<S, T>
    extends org.osgi.util.tracker.ServiceTracker<S, T> {
        public BundleContext getContext() {
            return this.context;
        }

        private ServiceTracker(BundleContext bundleContext, Class<S> clazz, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
            super(bundleContext, clazz, serviceTrackerCustomizer);
        }

        private ServiceTracker(BundleContext bundleContext, Filter filter, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
            super(bundleContext, filter, serviceTrackerCustomizer);
        }
    }
}

