/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.module.util;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SystemBundleUtil {
    private static final SystemBundleProvider _systemBundleProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S, R, E extends Throwable> R callService(Class<S> serviceClass, UnsafeFunction<S, R, E> unsafeFunction) throws E {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            return (R)unsafeFunction.apply(null);
        }
        Object service = bundleContext.getService(serviceReference);
        try {
            Object object = unsafeFunction.apply(service);
            return (R)object;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S, R, E extends Throwable> R callService(String serviceClassName, UnsafeFunction<S, R, E> unsafeFunction) throws E {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(serviceClassName);
        if (serviceReference == null) {
            return (R)unsafeFunction.apply(null);
        }
        Object service = bundleContext.getService(serviceReference);
        try {
            Object object = unsafeFunction.apply(service);
            return (R)object;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    public static Filter createFilter(String filterString) {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        try {
            return bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException(invalidSyntaxException);
        }
    }

    public static BundleContext getBundleContext() {
        Bundle systemBundle = _systemBundleProvider.getSystemBundle();
        if (systemBundle == null) {
            throw new IllegalStateException("System bundle is not initialized");
        }
        return systemBundle.getBundleContext();
    }

    public static ServiceLatch newServiceLatch() {
        return new ServiceLatch(SystemBundleUtil.getBundleContext());
    }

    static {
        ServiceLoader<SystemBundleProvider> serviceLoader = ServiceLoader.load(SystemBundleProvider.class, SystemBundleUtil.class.getClassLoader());
        Iterator<SystemBundleProvider> iterator = serviceLoader.iterator();
        ArrayList systemBundleProviders = new ArrayList();
        iterator.forEachRemaining(systemBundleProviders::add);
        if (systemBundleProviders.isEmpty()) {
            throw new ExceptionInInitializerError("Unable to locate module framework implementation");
        }
        systemBundleProviders.sort(Comparator.reverseOrder());
        _systemBundleProvider = (SystemBundleProvider)systemBundleProviders.get(0);
    }
}

